/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.interceptor;

import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.struts2.ServletActionContext;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.redback.authorization.AuthorizationResult;
import org.codehaus.plexus.redback.struts2.interceptor.AbstractHttpRequestTrackerInterceptor;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.redback.integration.interceptor.SecureAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

public class SecureActionInterceptor
extends AbstractHttpRequestTrackerInterceptor {
    private static final String REQUIRES_AUTHORIZATION = "requires-authorization";
    private static final String REQUIRES_AUTHENTICATION = "requires-authentication";
    private SecuritySystem securitySystem;
    private String trackerName;

    public void destroy() {
    }

    protected String getTrackerName() {
        return this.trackerName;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        ActionContext context = ActionContext.getContext();
        Action action = (Action)context.getActionInvocation().getAction();
        this.logger.debug("SecureActionInterceptor: processing " + action.getClass().getName());
        try {
            if (action instanceof SecureAction) {
                SecureAction secureAction = (SecureAction)action;
                SecureActionBundle bundle = secureAction.getSecureActionBundle();
                if (bundle == null) {
                    this.logger.error("Null bundle detected.");
                    return invocation.invoke();
                }
                if (bundle == SecureActionBundle.OPEN) {
                    this.logger.debug("Bundle.OPEN detected.");
                    return invocation.invoke();
                }
                SecuritySession session = (SecuritySession)context.getSession().get("securitySession");
                if (bundle.requiresAuthentication() && (session == null || !session.isAuthenticated())) {
                    this.logger.debug("not authenticated, need to authenticate for this action");
                    return this.processRequiresAuthentication(invocation);
                }
                List authzTuples = bundle.getAuthorizationTuples();
                if (authzTuples != null && authzTuples.size() > 0) {
                    if (session == null) {
                        this.logger.debug("session required for authorization to run");
                        return this.processRequiresAuthentication(invocation);
                    }
                    for (SecureActionBundle.AuthorizationTuple tuple : authzTuples) {
                        this.logger.debug("checking authz for " + tuple.toString());
                        AuthorizationResult authzResult = this.securitySystem.authorize(session, (Object)tuple.getOperation(), (Object)tuple.getResource());
                        this.logger.debug("checking the interceptor authz " + authzResult.isAuthorized() + " for " + tuple.toString());
                        if (!authzResult.isAuthorized()) continue;
                        this.logger.debug(session.getUser().getPrincipal() + " is authorized for action " + secureAction.getClass().getName() + " by " + tuple.toString());
                        return invocation.invoke();
                    }
                    return this.processRequiresAuthorization(invocation);
                }
            } else {
                this.logger.debug("SecureActionInterceptor: " + action.getClass().getName() + " not a secure action");
            }
        }
        catch (SecureActionException se) {
            this.logger.error("can't generate the SecureActionBundle, deny access: " + se.getMessage());
            return this.processRequiresAuthentication(invocation);
        }
        this.logger.debug("not a secure action " + action.getClass().getName());
        String result = invocation.invoke();
        this.logger.debug("Passing invocation up, result is [" + result + "] on call " + invocation.getAction().getClass().getName());
        return result;
    }

    protected String processRequiresAuthorization(ActionInvocation invocation) throws ComponentLookupException {
        this.addActionInvocation(invocation).setBackTrack();
        return REQUIRES_AUTHORIZATION;
    }

    protected String processRequiresAuthentication(ActionInvocation invocation) throws ComponentLookupException {
        HttpSession session = ServletActionContext.getRequest().getSession();
        if (session != null) {
            session.removeAttribute("securitySession");
        }
        this.addActionInvocation(invocation).setBackTrack();
        return REQUIRES_AUTHENTICATION;
    }
}

