/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.role.model.ModelApplication;
import org.codehaus.plexus.redback.role.model.ModelRole;
import org.codehaus.plexus.redback.role.model.ModelTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationRoleDetails {
    private String name;
    private String description;
    private List<String> assignedRoles;
    private List<String> availableRoles;
    private List<ModelTemplate> tableHeader;
    private List<List<RoleTableCell>> table;

    public ApplicationRoleDetails(ModelApplication application, Collection<Role> effectivelyAssignedRoles, Collection<Role> allAssignedRoles, List<Role> assignableRoles) {
        this.name = application.getId();
        this.description = application.getDescription();
        List templates = application.getTemplates();
        List roles = application.getRoles();
        this.tableHeader = new LinkedList<ModelTemplate>(templates);
        this.computeRoles(roles, assignableRoles, effectivelyAssignedRoles, allAssignedRoles);
        this.computeTable(this.gatherResources(templates, assignableRoles), effectivelyAssignedRoles, allAssignedRoles);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getAssignedRoles() {
        return this.assignedRoles;
    }

    public List<String> getAvailableRoles() {
        return this.availableRoles;
    }

    public List<ModelTemplate> getTableHeader() {
        return this.tableHeader;
    }

    public List<List<RoleTableCell>> getTable() {
        return this.table;
    }

    private void computeRoles(Collection<ModelRole> applicationRoles, Collection<Role> assignableRoles, Collection<Role> effectivelyAssignedRoles, Collection<Role> allAssignedRoles) {
        this.assignedRoles = new ArrayList<String>();
        this.availableRoles = new ArrayList<String>();
        for (ModelRole role : applicationRoles) {
            if (this.isInList(role.getName(), allAssignedRoles)) {
                if (!role.isAssignable()) continue;
                this.assignedRoles.add(role.getName());
                continue;
            }
            if (this.isInList(role.getName(), effectivelyAssignedRoles) || !this.isInList(role.getName(), assignableRoles) || !role.isAssignable()) continue;
            this.availableRoles.add(role.getName());
        }
        Collections.sort(this.assignedRoles, String.CASE_INSENSITIVE_ORDER);
        Collections.sort(this.availableRoles, String.CASE_INSENSITIVE_ORDER);
    }

    private Set<String> gatherResources(List<ModelTemplate> applicationTemplates, List<Role> roles) {
        HashSet<String> resources = new HashSet<String>();
        for (ModelTemplate modelTemplate : applicationTemplates) {
            for (Role role : roles) {
                String roleName = role.getName();
                if (!roleName.startsWith(modelTemplate.getNamePrefix())) continue;
                String delimiter = modelTemplate.getDelimiter();
                resources.add(roleName.substring(roleName.indexOf(delimiter) + delimiter.length()));
            }
        }
        return resources;
    }

    private void computeTable(Collection<String> resources, Collection<Role> effectivelyAssignedRoles, Collection<Role> allAssignedRoles) {
        this.table = new LinkedList<List<RoleTableCell>>();
        ArrayList<String> resourcesList = new ArrayList<String>(resources);
        Collections.sort(resourcesList, String.CASE_INSENSITIVE_ORDER);
        for (String resource : resourcesList) {
            LinkedList<RoleTableCell> tableRow = new LinkedList<RoleTableCell>();
            RoleTableCell resourceCell = new RoleTableCell();
            resourceCell.setName(resource);
            resourceCell.setLabel(true);
            tableRow.add(resourceCell);
            for (ModelTemplate modelTemplate : this.tableHeader) {
                RoleTableCell cell = new RoleTableCell();
                cell.setName(modelTemplate.getNamePrefix() + modelTemplate.getDelimiter() + resource);
                cell.setEffectivelyAssigned(this.isInList(cell.getName(), effectivelyAssignedRoles));
                cell.setAssigned(this.isInList(cell.getName(), allAssignedRoles));
                cell.setLabel(false);
                tableRow.add(cell);
            }
            this.table.add(tableRow);
        }
    }

    private boolean isInList(String roleName, Collection<Role> effectivelyAssignedRoles) {
        for (Role role : effectivelyAssignedRoles) {
            if (!roleName.equals(role.getName())) continue;
            return true;
        }
        return false;
    }

    public class RoleTableCell {
        private String name;
        private boolean effectivelyAssigned;
        private boolean assigned;
        private boolean label;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isEffectivelyAssigned() {
            return this.effectivelyAssigned;
        }

        public void setEffectivelyAssigned(boolean effectivelyAssigned) {
            this.effectivelyAssigned = effectivelyAssigned;
        }

        public boolean isAssigned() {
            return this.assigned;
        }

        public void setAssigned(boolean assigned) {
            this.assigned = assigned;
        }

        public boolean isLabel() {
            return this.label;
        }

        public void setLabel(boolean label) {
            this.label = label;
        }
    }
}

