/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.result;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.struts2.dispatcher.ServletActionRedirectResult;
import org.codehaus.plexus.redback.struts2.interceptor.ActionInvocationTracker;
import org.codehaus.plexus.redback.struts2.interceptor.SavedActionInvocation;

public class AbstractBackTrackingResult
extends ServletActionRedirectResult {
    public static final int PREVIOUS = 1;
    public static final int CURRENT = 2;

    protected boolean setupBackTrackPrevious(ActionInvocation invocation) {
        return this.setupBackTrack(invocation, 1);
    }

    protected boolean setupBackTrackCurrent(ActionInvocation invocation) {
        return this.setupBackTrack(invocation, 2);
    }

    protected boolean setupBackTrack(ActionInvocation invocation, int order) {
        Map session = invocation.getInvocationContext().getSession();
        ActionInvocationTracker tracker = (ActionInvocationTracker)session.get(ActionInvocationTracker.ROLE);
        if (tracker != null && tracker.isBackTracked()) {
            SavedActionInvocation savedInvocation = order == 1 ? tracker.getPrevious() : tracker.getCurrent();
            if (savedInvocation != null) {
                this.setNamespace(savedInvocation.getNamespace());
                this.setActionName(savedInvocation.getActionName());
                this.setMethod(savedInvocation.getMethodName());
                invocation.getInvocationContext().getParameters().putAll(savedInvocation.getParametersMap());
                String resultCode = invocation.getResultCode();
                if (resultCode != null) {
                    ResultConfig resultConfig = (ResultConfig)invocation.getProxy().getConfig().getResults().get(resultCode);
                    HashMap<String, String> filteredMap = new HashMap<String, String>();
                    Set<String> keys = savedInvocation.getParametersMap().keySet();
                    for (String key : keys) {
                        filteredMap.put(key, "");
                    }
                    resultConfig.getParams().putAll(filteredMap);
                }
                tracker.unsetBackTrack();
            }
            return true;
        }
        return false;
    }
}

