/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.users;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserManagerListener;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserManager
implements UserManager {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private List<UserManagerListener> listeners = new ArrayList<UserManagerListener>();

    public void addUserManagerListener(UserManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeUserManagerListener(UserManagerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireUserManagerInit(boolean freshDatabase) {
        for (UserManagerListener listener : this.listeners) {
            try {
                listener.userManagerInit(freshDatabase);
            }
            catch (Exception e) {}
        }
    }

    protected void fireUserManagerUserAdded(User addedUser) {
        for (UserManagerListener listener : this.listeners) {
            try {
                listener.userManagerUserAdded(addedUser);
            }
            catch (Exception e) {}
        }
    }

    protected void fireUserManagerUserRemoved(User removedUser) {
        for (UserManagerListener listener : this.listeners) {
            try {
                listener.userManagerUserRemoved(removedUser);
            }
            catch (Exception e) {}
        }
    }

    protected void fireUserManagerUserUpdated(User updatedUser) {
        for (UserManagerListener listener : this.listeners) {
            try {
                listener.userManagerUserUpdated(updatedUser);
            }
            catch (Exception e) {}
        }
    }

    public User getGuestUser() throws UserNotFoundException {
        return this.findUser("guest");
    }

    public User createGuestUser() {
        try {
            User u = this.getGuestUser();
            if (u != null) {
                return u;
            }
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        User user = this.createUser("guest", "Guest", "");
        user.setPermanent(true);
        user.setPasswordChangeRequired(false);
        user = this.addUser(user);
        return user;
    }
}

