/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.users.cached;

import java.util.List;
import javax.annotation.Resource;
import org.codehaus.plexus.cache.Cache;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserManagerListener;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.redback.users.UserQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="userManager#cached")
public class CachedUserManager
implements UserManager,
UserManagerListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource(name="userManager#jdo")
    private UserManager userImpl;
    @Resource(name="cache#users")
    private Cache usersCache;

    public boolean isReadOnly() {
        return this.userImpl.isReadOnly();
    }

    public User createGuestUser() {
        return this.userImpl.createGuestUser();
    }

    public User addUser(User user) {
        if (user != null) {
            this.usersCache.remove(user.getPrincipal());
        }
        return this.userImpl.addUser(user);
    }

    public void addUserManagerListener(UserManagerListener listener) {
        this.userImpl.addUserManagerListener(listener);
    }

    public void addUserUnchecked(User user) {
        if (user != null) {
            this.usersCache.remove(user.getPrincipal());
        }
        this.userImpl.addUserUnchecked(user);
    }

    public User createUser(String username, String fullName, String emailAddress) {
        this.usersCache.remove((Object)username);
        return this.userImpl.createUser(username, fullName, emailAddress);
    }

    public void deleteUser(Object principal) throws UserNotFoundException {
        this.usersCache.remove(principal);
        this.userImpl.deleteUser(principal);
    }

    public void deleteUser(String username) throws UserNotFoundException {
        this.usersCache.remove((Object)username);
        this.userImpl.deleteUser(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseDatabase() {
        try {
            this.userImpl.eraseDatabase();
        }
        finally {
            this.usersCache.clear();
        }
    }

    public User findUser(String username) throws UserNotFoundException {
        if ("guest".equals(username)) {
            return this.getGuestUser();
        }
        Object el = this.usersCache.get((Object)username);
        if (el != null) {
            return (User)el;
        }
        User user = this.userImpl.findUser(username);
        this.usersCache.put((Object)username, (Object)user);
        return user;
    }

    public User getGuestUser() throws UserNotFoundException {
        Object el = this.usersCache.get((Object)"guest");
        if (el != null) {
            return (User)el;
        }
        User user = this.userImpl.getGuestUser();
        this.usersCache.put((Object)"guest", (Object)user);
        return user;
    }

    public User findUser(Object principal) throws UserNotFoundException {
        Object el = this.usersCache.get(principal);
        if (el != null) {
            return (User)el;
        }
        User user = this.userImpl.findUser(principal);
        this.usersCache.put(principal, (Object)user);
        return user;
    }

    public UserQuery createUserQuery() {
        return this.userImpl.createUserQuery();
    }

    public List<User> findUsersByQuery(UserQuery query) {
        this.log.debug("NOT CACHED - .findUsersByQuery(UserQuery)");
        return this.userImpl.findUsersByQuery(query);
    }

    public List<User> findUsersByEmailKey(String emailKey, boolean orderAscending) {
        this.log.debug("NOT CACHED - .findUsersByEmailKey(String, boolean)");
        return this.userImpl.findUsersByEmailKey(emailKey, orderAscending);
    }

    public List<User> findUsersByFullNameKey(String fullNameKey, boolean orderAscending) {
        this.log.debug("NOT CACHED - .findUsersByFullNameKey(String, boolean)");
        return this.userImpl.findUsersByFullNameKey(fullNameKey, orderAscending);
    }

    public List<User> findUsersByUsernameKey(String usernameKey, boolean orderAscending) {
        this.log.debug("NOT CACHED - .findUsersByUsernameKey(String, boolean)");
        return this.userImpl.findUsersByUsernameKey(usernameKey, orderAscending);
    }

    public String getId() {
        return "Cached User Manager [" + this.userImpl.getId() + "]";
    }

    public List<User> getUsers() {
        this.log.debug("NOT CACHED - .getUsers()");
        return this.userImpl.getUsers();
    }

    public List<User> getUsers(boolean orderAscending) {
        this.log.debug("NOT CACHED - .getUsers(boolean)");
        return this.userImpl.getUsers(orderAscending);
    }

    public void removeUserManagerListener(UserManagerListener listener) {
        this.userImpl.removeUserManagerListener(listener);
    }

    public User updateUser(User user) throws UserNotFoundException {
        if (user != null) {
            this.usersCache.remove(user.getPrincipal());
        }
        return this.userImpl.updateUser(user);
    }

    public boolean userExists(Object principal) {
        if (this.usersCache.hasKey(principal)) {
            return true;
        }
        return this.userImpl.userExists(principal);
    }

    public void userManagerInit(boolean freshDatabase) {
        if (this.userImpl instanceof UserManager) {
            ((UserManagerListener)this.userImpl).userManagerInit(freshDatabase);
        }
        this.usersCache.clear();
    }

    public void userManagerUserAdded(User user) {
        if (this.userImpl instanceof UserManager) {
            ((UserManagerListener)this.userImpl).userManagerUserAdded(user);
        }
        if (user != null) {
            this.usersCache.remove(user.getPrincipal());
        }
    }

    public void userManagerUserRemoved(User user) {
        if (this.userImpl instanceof UserManager) {
            ((UserManagerListener)this.userImpl).userManagerUserRemoved(user);
        }
        if (user != null) {
            this.usersCache.remove(user.getPrincipal());
        }
    }

    public void userManagerUserUpdated(User user) {
        if (this.userImpl instanceof UserManager) {
            ((UserManagerListener)this.userImpl).userManagerUserUpdated(user);
        }
        if (user != null) {
            this.usersCache.remove(user.getPrincipal());
        }
    }
}

