/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.users.ldap;

import java.util.ArrayList;
import java.util.List;
import javax.naming.directory.DirContext;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.redback.common.ldap.MappingException;
import org.codehaus.plexus.redback.common.ldap.UserMapper;
import org.codehaus.plexus.redback.common.ldap.connection.LdapConnection;
import org.codehaus.plexus.redback.common.ldap.connection.LdapConnectionFactory;
import org.codehaus.plexus.redback.common.ldap.connection.LdapException;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserManagerListener;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.redback.users.UserQuery;
import org.codehaus.plexus.redback.users.ldap.ctl.LdapController;
import org.codehaus.plexus.redback.users.ldap.ctl.LdapControllerException;

public class LdapUserManager
implements UserManager,
LogEnabled {
    private LdapConnectionFactory connectionFactory;
    private List<UserManagerListener> listeners = new ArrayList<UserManagerListener>();
    private Logger logger;
    private LdapController controller;
    private UserMapper mapper;

    public boolean isReadOnly() {
        return true;
    }

    public void addUserManagerListener(UserManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeUserManagerListener(UserManagerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireUserAdded(User addedUser) {
        for (UserManagerListener listener : this.listeners) {
            try {
                listener.userManagerUserAdded(addedUser);
            }
            catch (Exception e) {
                this.getLogger().debug("Failed to fire user-added event to user-manager: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void fireUserRemoved(User removedUser) {
        for (UserManagerListener listener : this.listeners) {
            try {
                listener.userManagerUserRemoved(removedUser);
            }
            catch (Exception e) {
                this.getLogger().debug("Failed to fire user-removed event to user-manager: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void fireUserUpdated(User updatedUser) {
        for (UserManagerListener listener : this.listeners) {
            try {
                listener.userManagerUserUpdated(updatedUser);
            }
            catch (Exception e) {
                this.getLogger().debug("Failed to fire user-updated event to user-manager: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public User addUser(User user) {
        DirContext context = this.newDirContext();
        try {
            this.controller.createUser(user, context, true);
        }
        catch (LdapControllerException e) {
            this.getLogger().error("Error mapping user: " + user.getPrincipal() + " to LDAP attributes.", (Throwable)e);
        }
        catch (MappingException e) {
            this.getLogger().error("Error mapping user: " + user.getPrincipal() + " to LDAP attributes.", (Throwable)e);
        }
        return user;
    }

    public void addUserUnchecked(User user) {
        DirContext context = this.newDirContext();
        try {
            this.controller.createUser(user, context, false);
        }
        catch (LdapControllerException e) {
            this.getLogger().error("Error mapping user: " + user.getPrincipal() + " to LDAP attributes.", (Throwable)e);
        }
        catch (MappingException e) {
            this.getLogger().error("Error mapping user: " + user.getPrincipal() + " to LDAP attributes.", (Throwable)e);
        }
    }

    public User createUser(String username, String fullName, String emailAddress) {
        return this.mapper.newUserInstance(username, fullName, emailAddress);
    }

    public UserQuery createUserQuery() {
        return null;
    }

    public void deleteUser(Object principal) throws UserNotFoundException {
        try {
            this.controller.removeUser(principal, this.newDirContext());
        }
        catch (LdapControllerException e) {
            this.getLogger().error("Failed to delete user: " + principal, (Throwable)e);
        }
    }

    public void deleteUser(String username) throws UserNotFoundException {
        try {
            this.controller.removeUser(username, this.newDirContext());
        }
        catch (LdapControllerException e) {
            this.getLogger().error("Failed to delete user: " + username, (Throwable)e);
        }
    }

    public void eraseDatabase() {
    }

    public User findUser(String username) throws UserNotFoundException {
        try {
            return this.controller.getUser(username, this.newDirContext());
        }
        catch (LdapControllerException e) {
            this.getLogger().error("Failed to find user: " + username, (Throwable)e);
            return null;
        }
        catch (MappingException e) {
            this.getLogger().error("Failed to map user: " + username, (Throwable)e);
            return null;
        }
    }

    public User findUser(Object principal) throws UserNotFoundException {
        try {
            return this.controller.getUser(principal, this.newDirContext());
        }
        catch (LdapControllerException e) {
            this.getLogger().error("Failed to find user: " + principal, (Throwable)e);
            return null;
        }
        catch (MappingException e) {
            this.getLogger().error("Failed to map user: " + principal, (Throwable)e);
            return null;
        }
    }

    public List findUsersByEmailKey(String emailKey, boolean orderAscending) {
        return null;
    }

    public List findUsersByFullNameKey(String fullNameKey, boolean orderAscending) {
        return null;
    }

    public List findUsersByQuery(UserQuery query) {
        return null;
    }

    public List findUsersByUsernameKey(String usernameKey, boolean orderAscending) {
        return null;
    }

    public String getId() {
        return "LDAP User-Manager: " + this.getClass().getName();
    }

    public List getUsers() {
        try {
            ArrayList<User> users = new ArrayList<User>();
            users.addAll(this.controller.getUsers(this.newDirContext()));
            return users;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List getUsers(boolean orderAscending) {
        return this.getUsers();
    }

    public User updateUser(User user) throws UserNotFoundException {
        try {
            this.controller.updateUser(user, this.newDirContext());
        }
        catch (LdapControllerException e) {
            this.getLogger().error("Failed to update user: " + user.getPrincipal(), (Throwable)e);
        }
        catch (MappingException e) {
            this.getLogger().error("Failed to update user: " + user.getPrincipal(), (Throwable)e);
        }
        return user;
    }

    public boolean userExists(Object principal) {
        DirContext context = this.newDirContext();
        try {
            return this.controller.userExists(principal, context);
        }
        catch (LdapControllerException e) {
            this.getLogger().debug("Failed to search for user: " + principal, (Throwable)e);
            return false;
        }
    }

    private DirContext newDirContext() {
        try {
            LdapConnection connection = this.connectionFactory.getConnection();
            return connection.getDirContext();
        }
        catch (LdapException le) {
            le.printStackTrace();
            return null;
        }
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(0, "internally-initialized");
        }
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public LdapConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(LdapConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

