/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.users.ldap.ctl;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.redback.common.ldap.LdapUser;
import org.codehaus.plexus.redback.common.ldap.MappingException;
import org.codehaus.plexus.redback.common.ldap.UserMapper;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.ldap.ctl.LdapController;
import org.codehaus.plexus.redback.users.ldap.ctl.LdapControllerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLdapController
implements LogEnabled,
LdapController {
    private Logger log;
    private UserMapper mapper;

    @Override
    public void removeUser(Object principal, DirContext context) throws LdapControllerException {
    }

    @Override
    public void updateUser(User user, DirContext context) throws LdapControllerException, MappingException {
    }

    @Override
    public boolean userExists(Object key, DirContext context) throws LdapControllerException {
        try {
            return this.searchUsers(key, context).hasMoreElements();
        }
        catch (NamingException e) {
            throw new LdapControllerException("Error searching for the existence of user: " + key, e);
        }
    }

    protected NamingEnumeration<SearchResult> searchUsers(Object key, DirContext context) throws NamingException {
        return this.searchUsers(key, context, null);
    }

    protected NamingEnumeration<SearchResult> searchUsers(DirContext context) throws NamingException {
        return this.searchUsers(null, context, null);
    }

    protected NamingEnumeration<SearchResult> searchUsers(DirContext context, String[] returnAttributes) throws NamingException {
        return this.searchUsers(null, context, returnAttributes);
    }

    protected NamingEnumeration<SearchResult> searchUsers(Object key, DirContext context, String[] returnAttributes) throws NamingException {
        String[] userAttributes = returnAttributes;
        if (userAttributes == null) {
            userAttributes = this.mapper.getUserAttributeNames();
        }
        SearchControls ctls = new SearchControls();
        if (key != null) {
            ctls.setCountLimit(0L);
        }
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"*"});
        String filter = "(&(objectClass=" + this.mapper.getUserObjectClass() + ")" + (this.mapper.getUserFilter() != null ? this.mapper.getUserFilter() : "") + "(" + this.mapper.getUserIdAttribute() + "=" + (key != null ? key : "*") + "))";
        this.log.info("Searching for users with filter: '" + filter + "'" + " from base dn: " + this.mapper.getUserBaseDn());
        return context.search(this.mapper.getUserBaseDn(), filter, ctls);
    }

    @Override
    public Collection<User> getUsers(DirContext context) throws LdapControllerException, MappingException {
        try {
            NamingEnumeration<SearchResult> results = this.searchUsers(null, context, null);
            LinkedHashSet<User> users = new LinkedHashSet<User>();
            while (results.hasMoreElements()) {
                SearchResult result = (SearchResult)results.nextElement();
                users.add((User)this.mapper.getUser(result.getAttributes()));
            }
            return users;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve ldap information for users.";
            throw new LdapControllerException(message, e);
        }
    }

    @Override
    public void createUser(User user, DirContext context, boolean encodePasswordIfChanged) throws LdapControllerException, MappingException {
    }

    @Override
    public LdapUser getUser(Object key, DirContext context) throws LdapControllerException, MappingException {
        String username = key.toString();
        this.log.info("Searching for user: " + username);
        try {
            NamingEnumeration<SearchResult> result = this.searchUsers(username, context, null);
            if (result.hasMoreElements()) {
                SearchResult next = (SearchResult)result.nextElement();
                return this.mapper.getUser(next.getAttributes());
            }
            return null;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve information for user: " + username;
            throw new LdapControllerException(message, e);
        }
    }

    @Override
    public void enableLogging(Logger logger) {
        this.log = logger;
    }
}

