/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.control;

import java.net.URI;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.EagerInit;
import org.sca4j.binding.jms.common.JmsBindingMetadata;
import org.sca4j.binding.jms.common.TransactionType;
import org.sca4j.binding.jms.provision.JmsWireSourceDefinition;
import org.sca4j.binding.jms.provision.JmsWireTargetDefinition;
import org.sca4j.binding.jms.scdl.JmsBindingDefinition;
import org.sca4j.scdl.Operation;
import org.sca4j.scdl.ReferenceDefinition;
import org.sca4j.scdl.ServiceContract;
import org.sca4j.scdl.ServiceDefinition;
import org.sca4j.scdl.definitions.Intent;
import org.sca4j.spi.generator.BindingGenerator;
import org.sca4j.spi.generator.GenerationException;
import org.sca4j.spi.model.instance.Bindable;
import org.sca4j.spi.model.instance.LogicalBinding;
import org.sca4j.spi.model.instance.LogicalComponent;
import org.sca4j.spi.policy.Policy;

@EagerInit
public class JmsBindingGenerator
implements BindingGenerator<JmsWireSourceDefinition, JmsWireTargetDefinition, JmsBindingDefinition> {
    private static final QName TRANSACTED_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "transactedOneWay");
    private static final QName TRANSACTED_ONEWAY_LOCAL = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "transactedOneWay.local");
    private static final QName TRANSACTED_ONEWAY_GLOBAL = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "transactedOneWay.global");

    public JmsWireSourceDefinition generateWireSource(LogicalBinding<JmsBindingDefinition> logicalBinding, Policy policy, ServiceDefinition serviceDefinition) throws GenerationException {
        ServiceContract serviceContract = serviceDefinition.getServiceContract();
        if (serviceContract.getOperations().size() != 1) {
            throw new GenerationException("Services with JMS binding can have only one operation");
        }
        if (((Operation)serviceContract.getOperations().get(0)).getInputTypes().size() != 1) {
            throw new GenerationException("Services with JMS binding can have only one operation with one parameter");
        }
        TransactionType transactionType = this.getTransactionType(policy, serviceContract);
        URI classloaderId = ((LogicalComponent)((Bindable)logicalBinding.getParent()).getParent()).getClassLoaderId();
        JmsBindingMetadata metadata = ((JmsBindingDefinition)logicalBinding.getBinding()).getMetadata();
        URI uri = ((JmsBindingDefinition)logicalBinding.getBinding()).getTargetUri();
        return new JmsWireSourceDefinition(uri, metadata, transactionType, classloaderId);
    }

    public JmsWireTargetDefinition generateWireTarget(LogicalBinding<JmsBindingDefinition> logicalBinding, Policy policy, ReferenceDefinition referenceDefinition) throws GenerationException {
        ServiceContract serviceContract = referenceDefinition.getServiceContract();
        if (serviceContract.getOperations().size() != 1) {
            throw new GenerationException("References with on JMS binding can have only one operation");
        }
        if (((Operation)serviceContract.getOperations().get(0)).getInputTypes().size() != 1) {
            throw new GenerationException("References with JMS binding can have only one operation with one parameter");
        }
        TransactionType transactionType = this.getTransactionType(policy, serviceContract);
        URI classloaderId = ((LogicalComponent)((Bindable)logicalBinding.getParent()).getParent()).getClassLoaderId();
        URI uri = ((JmsBindingDefinition)logicalBinding.getBinding()).getTargetUri();
        JmsBindingMetadata metadata = ((JmsBindingDefinition)logicalBinding.getBinding()).getMetadata();
        return new JmsWireTargetDefinition(uri, metadata, transactionType, classloaderId);
    }

    private TransactionType getTransactionType(Policy policy, ServiceContract serviceContract) {
        for (Operation operation : serviceContract.getOperations()) {
            for (Intent intent : policy.getProvidedIntents(operation)) {
                if (TRANSACTED_ONEWAY_GLOBAL.equals(intent.getName())) {
                    return TransactionType.GLOBAL;
                }
                if (TRANSACTED_ONEWAY_LOCAL.equals(intent.getName())) {
                    return TransactionType.LOCAL;
                }
                if (!TRANSACTED_ONEWAY.equals(intent.getName())) continue;
                return TransactionType.GLOBAL;
            }
        }
        return TransactionType.LOCAL;
    }
}

