/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.introspection;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;
import org.sca4j.binding.jms.common.Correlation;
import org.sca4j.binding.jms.common.JmsBindingMetadata;
import org.sca4j.binding.jms.scdl.JmsBindingDefinition;
import org.sca4j.host.contribution.ValidationFailure;
import org.sca4j.introspection.IntrospectionContext;
import org.sca4j.introspection.xml.LoaderHelper;
import org.sca4j.introspection.xml.TypeLoader;
import org.sca4j.introspection.xml.UnrecognizedAttribute;
import org.sca4j.scdl.PolicyAware;

@EagerInit
public class JmsBindingLoader
implements TypeLoader<JmsBindingDefinition> {
    public static final QName BINDING_QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.jms");
    private static final Set<String> ATTRIBUTES = new HashSet<String>();
    private final LoaderHelper loaderHelper;

    public JmsBindingLoader(@Reference LoaderHelper loaderHelper) {
        this.loaderHelper = loaderHelper;
    }

    public JmsBindingDefinition load(XMLStreamReader reader, IntrospectionContext introspectionContext) throws XMLStreamException {
        String batchSize;
        String batched;
        String consumerCount;
        String exceptionTimeout;
        this.validateAttributes(reader, introspectionContext);
        JmsBindingMetadata metadata = new JmsBindingMetadata();
        JmsBindingDefinition bd = new JmsBindingDefinition(metadata, this.loaderHelper.loadKey(reader));
        String correlationScheme = reader.getAttributeValue(null, "correlationScheme");
        if (correlationScheme != null) {
            metadata.correlation = Correlation.valueOf(correlationScheme);
        }
        metadata.jndiUrl = reader.getAttributeValue(null, "jndiURL");
        metadata.initialContextFactory = reader.getAttributeValue(null, "initialContextFactory");
        metadata.destinationName = reader.getAttributeValue(null, "destination");
        metadata.connectionFactoryName = reader.getAttributeValue(null, "connectionFactory");
        metadata.responseDestinationName = reader.getAttributeValue(null, "responseDestination");
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)bd, reader, introspectionContext);
        String pollingInterval = reader.getAttributeValue("urn:sca4j.org", "pollingInterval");
        if (pollingInterval != null) {
            metadata.pollingInterval = Integer.parseInt(pollingInterval);
        }
        if ((exceptionTimeout = reader.getAttributeValue("urn:sca4j.org", "exceptionTimeout")) != null) {
            metadata.exceptionTimeout = Integer.parseInt(exceptionTimeout);
        }
        if ((consumerCount = reader.getAttributeValue("urn:sca4j.org", "consumerCount")) != null) {
            metadata.consumerCount = Integer.parseInt(consumerCount);
        }
        if ((batched = reader.getAttributeValue("urn:sca4j.org", "batched")) != null) {
            metadata.batched = Boolean.valueOf(batched);
        }
        if ((batchSize = reader.getAttributeValue("urn:sca4j.org", "batchSize")) != null) {
            metadata.batchSize = Integer.parseInt(batchSize);
        }
        this.loadOptionalElements(reader, metadata);
        return bd;
    }

    private void loadOptionalElements(XMLStreamReader reader, JmsBindingMetadata metadata) throws XMLStreamException {
        while (true) {
            String name;
            int event;
            if ((event = reader.next()) == 1) {
                name = reader.getName().getLocalPart();
                if (!"selector".equals(name)) continue;
                metadata.selector = reader.getElementText();
                continue;
            }
            if (event == 2 && "binding.jms".equals(name = reader.getName().getLocalPart())) break;
        }
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if (ATTRIBUTES.contains(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }

    static {
        ATTRIBUTES.add("uri");
        ATTRIBUTES.add("correlationScheme");
        ATTRIBUTES.add("jndiURL");
        ATTRIBUTES.add("initialContextFactory");
        ATTRIBUTES.add("requires");
        ATTRIBUTES.add("policySets");
        ATTRIBUTES.add("destination");
        ATTRIBUTES.add("responseDestination");
        ATTRIBUTES.add("connectionFactory");
        ATTRIBUTES.add("pollingInterval");
        ATTRIBUTES.add("exceptionTimeout");
        ATTRIBUTES.add("consumerCount");
        ATTRIBUTES.add("batched");
        ATTRIBUTES.add("batchSize");
        ATTRIBUTES.add("key");
    }
}

