/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.sca4j.binding.jms.common.TransactionType;

public class JMSObjectFactory {
    private final ConnectionFactory connectionFactory;
    private final Destination destination;
    private final Destination responseDestination;

    public JMSObjectFactory(ConnectionFactory connectionFactory, Destination destination, Destination responseDestination) {
        this.connectionFactory = connectionFactory;
        this.destination = destination;
        this.responseDestination = responseDestination;
    }

    public Destination getResponseDestination() {
        return this.responseDestination;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Connection getConnection() throws JMSException {
        return this.connectionFactory.createConnection();
    }

    public Destination getDestination() {
        return this.destination;
    }

    public Session getSession(Connection connection, TransactionType transactionType) throws JMSException {
        if (transactionType == TransactionType.LOCAL) {
            return connection.createSession(true, 1);
        }
        return connection.createSession(true, 0);
    }
}

