/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime;

import java.net.URI;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.transaction.TransactionManager;
import org.oasisopen.sca.annotation.Reference;
import org.sca4j.binding.jms.common.JmsBindingMetadata;
import org.sca4j.binding.jms.common.TransactionType;
import org.sca4j.binding.jms.provision.JmsWireSourceDefinition;
import org.sca4j.binding.jms.runtime.JMSObjectFactory;
import org.sca4j.binding.jms.runtime.helper.JndiHelper;
import org.sca4j.binding.jms.runtime.host.JmsHost;
import org.sca4j.spi.ObjectFactory;
import org.sca4j.spi.builder.WiringException;
import org.sca4j.spi.builder.component.SourceWireAttacher;
import org.sca4j.spi.model.physical.PhysicalWireTargetDefinition;
import org.sca4j.spi.wire.Wire;

public class JmsSourceWireAttacher
implements SourceWireAttacher<JmsWireSourceDefinition> {
    @Reference
    public JmsHost jmsHost;
    @Reference(required=false)
    public TransactionManager transactionManager;

    public void attachToSource(JmsWireSourceDefinition source, PhysicalWireTargetDefinition target, Wire wire) throws WiringException {
        URI serviceUri = target.getUri();
        JmsBindingMetadata metadata = source.getMetadata();
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (metadata.jndiUrl != null && !"".equals(metadata.jndiUrl)) {
            env.put("java.naming.provider.url", metadata.jndiUrl);
        }
        if (metadata.initialContextFactory != null && !"".equals(metadata.initialContextFactory)) {
            env.put("java.naming.factory.initial", metadata.initialContextFactory);
        }
        TransactionType transactionType = source.getTransactionType();
        String connectionFactoryName = metadata.connectionFactoryName;
        String destinationName = metadata.destinationName;
        String responseDestinationName = metadata.responseDestinationName;
        JMSObjectFactory jmsFactory = this.buildObjectFactory(connectionFactoryName, destinationName, responseDestinationName, env);
        this.jmsHost.register(jmsFactory, transactionType, wire, metadata, serviceUri);
    }

    public void detachFromSource(JmsWireSourceDefinition source, PhysicalWireTargetDefinition target, Wire wire) throws WiringException {
    }

    public void attachObjectFactory(JmsWireSourceDefinition source, ObjectFactory<?> objectFactory, PhysicalWireTargetDefinition definition) throws WiringException {
        throw new UnsupportedOperationException();
    }

    private JMSObjectFactory buildObjectFactory(String connectionFactoryName, String destinationName, String responseDestinationName, Hashtable<String, String> env) {
        Destination responseDestination = null;
        ConnectionFactory connectionFactory = (ConnectionFactory)JndiHelper.lookup(connectionFactoryName, env);
        Destination destination = (Destination)JndiHelper.lookup(destinationName, env);
        if (responseDestinationName != null) {
            responseDestination = (Destination)JndiHelper.lookup(responseDestinationName, env);
        }
        return new JMSObjectFactory(connectionFactory, destination, responseDestination);
    }
}

