/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime;

import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.transaction.TransactionManager;
import org.oasisopen.sca.annotation.Reference;
import org.sca4j.binding.jms.common.JmsBindingMetadata;
import org.sca4j.binding.jms.common.TransactionType;
import org.sca4j.binding.jms.provision.JmsWireTargetDefinition;
import org.sca4j.binding.jms.runtime.JMSObjectFactory;
import org.sca4j.binding.jms.runtime.helper.JndiHelper;
import org.sca4j.binding.jms.runtime.interceptor.AbstractInterceptor;
import org.sca4j.binding.jms.runtime.interceptor.OneWayGlobalInterceptor;
import org.sca4j.binding.jms.runtime.interceptor.OneWayLocalInterceptor;
import org.sca4j.binding.jms.runtime.interceptor.TwoWayGlobalInterceptor;
import org.sca4j.binding.jms.runtime.interceptor.TwoWayLocalInterceptor;
import org.sca4j.spi.ObjectFactory;
import org.sca4j.spi.builder.WiringException;
import org.sca4j.spi.builder.component.TargetWireAttacher;
import org.sca4j.spi.model.physical.PhysicalOperationDefinition;
import org.sca4j.spi.model.physical.PhysicalOperationPair;
import org.sca4j.spi.model.physical.PhysicalWireSourceDefinition;
import org.sca4j.spi.wire.Interceptor;
import org.sca4j.spi.wire.InvocationChain;
import org.sca4j.spi.wire.Wire;

public class JmsTargetWireAttacher
implements TargetWireAttacher<JmsWireTargetDefinition> {
    @Reference(required=false)
    public TransactionManager transactionManager;

    public void attachToTarget(PhysicalWireSourceDefinition sourceDefinition, JmsWireTargetDefinition targetDefinition, Wire wire) throws WiringException {
        JmsBindingMetadata metadata = targetDefinition.getMetadata();
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (metadata.jndiUrl != null && !"".equals(metadata.jndiUrl)) {
            env.put("java.naming.provider.url", metadata.jndiUrl);
        }
        if (metadata.initialContextFactory != null && !"".equals(metadata.initialContextFactory)) {
            env.put("java.naming.factory.initial", metadata.initialContextFactory);
        }
        TransactionType transactionType = targetDefinition.getTransactionType();
        String connectionFactoryName = metadata.connectionFactoryName;
        String destinationName = metadata.destinationName;
        String responseDestinationName = metadata.responseDestinationName;
        JMSObjectFactory jmsFactory = this.buildObjectFactory(connectionFactoryName, destinationName, responseDestinationName, env);
        AbstractInterceptor interceptor = null;
        boolean twoWay = this.isTwoWay(wire);
        interceptor = twoWay ? (transactionType == TransactionType.GLOBAL ? new TwoWayGlobalInterceptor(jmsFactory, this.transactionManager, metadata.correlation, wire) : new TwoWayLocalInterceptor(jmsFactory, metadata.correlation, wire)) : (transactionType == TransactionType.GLOBAL ? new OneWayGlobalInterceptor(jmsFactory, this.transactionManager, wire) : new OneWayLocalInterceptor(jmsFactory, wire));
        ((InvocationChain)wire.getInvocationChains().entrySet().iterator().next().getValue()).addInterceptor((Interceptor)interceptor);
    }

    public ObjectFactory<?> createObjectFactory(JmsWireTargetDefinition target) throws WiringException {
        throw new UnsupportedOperationException();
    }

    private JMSObjectFactory buildObjectFactory(String connectionFactoryName, String destinationName, String responseDestinationName, Hashtable<String, String> env) {
        ConnectionFactory connectionFactory = (ConnectionFactory)JndiHelper.lookup(connectionFactoryName, env);
        Destination destination = (Destination)JndiHelper.lookup(destinationName, env);
        Destination responseDestination = (Destination)JndiHelper.lookup(responseDestinationName, env);
        return new JMSObjectFactory(connectionFactory, destination, responseDestination);
    }

    private boolean isTwoWay(Wire wire) {
        PhysicalOperationDefinition operationDef = ((PhysicalOperationPair)wire.getInvocationChains().entrySet().iterator().next().getKey()).getSourceOperation();
        String returnType = operationDef.getReturnType();
        return returnType != null && returnType != "void";
    }
}

