/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.sca4j.binding.jms.common.SCA4JJmsException;
import org.sca4j.binding.jms.runtime.helper.JmsHelper;

public class SCA4JMessageReceiver {
    private Destination destination;
    private ConnectionFactory connectionFactory;

    public SCA4JMessageReceiver(Destination destination, ConnectionFactory connectionFactory) {
        this.destination = destination;
        this.connectionFactory = connectionFactory;
    }

    public Message receive(String correlationId) {
        Connection connection = null;
        try {
            connection = this.connectionFactory.createConnection();
            Session session = connection.createSession(true, 0);
            String selector = "JMSCorrelationID = '" + correlationId + "'";
            MessageConsumer consumer = session.createConsumer(this.destination, selector);
            connection.start();
            Message message = consumer.receive();
            session.commit();
            Message message2 = message;
            return message2;
        }
        catch (JMSException ex) {
            throw new SCA4JJmsException("Unable to receive response", ex);
        }
        finally {
            JmsHelper.closeQuietly(connection);
        }
    }
}

