/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime.helper;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.sca4j.binding.jms.common.SCA4JJmsException;

public class JndiHelper {
    private JndiHelper() {
    }

    public static <T> T lookup(String name, Hashtable<String, String> env) {
        if (name == null) {
            return null;
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(env);
            Object object = ctx.lookup(name);
            return (T)object;
        }
        catch (NameNotFoundException ex) {
            throw new SCA4JJmsException("Unable to lookup administered object", ex);
        }
        catch (NamingException ex) {
            throw new SCA4JJmsException("Unable to lookup administered object", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException ex) {
                throw new SCA4JJmsException("Unable to lookup administered object", ex);
            }
        }
    }
}

