/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime.host.standalone;

import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import org.sca4j.binding.jms.common.SCA4JJmsException;
import org.sca4j.binding.jms.runtime.host.standalone.ConsumerWorkerTemplate;
import org.sca4j.binding.jms.runtime.wireformat.DataBinder;
import org.sca4j.host.runtime.RuntimeLifecycle;
import org.sca4j.host.work.DefaultPausableWork;
import org.sca4j.spi.invocation.WorkContext;
import org.sca4j.spi.model.physical.PhysicalOperationDefinition;
import org.sca4j.spi.model.physical.PhysicalOperationPair;
import org.sca4j.spi.wire.InvocationChain;

public abstract class ConsumerWorker
extends DefaultPausableWork {
    protected ConsumerWorkerTemplate template;
    protected boolean exception;
    protected DataBinder dataBinder = new DataBinder();
    protected RuntimeLifecycle runtimeLifecycle;
    protected InvocationChain invocationChain;
    protected Class<?> inputType;

    public ConsumerWorker(ConsumerWorkerTemplate template, RuntimeLifecycle runtimeLifecycle) {
        super(true);
        try {
            this.template = template;
            PhysicalOperationDefinition pod = ((PhysicalOperationPair)template.wire.getInvocationChains().entrySet().iterator().next().getKey()).getTargetOperation();
            this.invocationChain = (InvocationChain)template.wire.getInvocationChains().entrySet().iterator().next().getValue();
            this.inputType = Class.forName((String)pod.getParameters().get(0));
            this.runtimeLifecycle = runtimeLifecycle;
        }
        catch (ClassNotFoundException e) {
            throw new SCA4JJmsException("Unable to load operation types", e);
        }
    }

    protected void copyHeaders(Message jmsRequest, WorkContext workContext) throws JMSException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("JMSCorrelationId", jmsRequest.getJMSCorrelationID());
        headers.put("JMSMessageId", jmsRequest.getJMSMessageID());
        headers.put("JMSRedelivered", jmsRequest.getJMSRedelivered());
        headers.put("JMSType", jmsRequest.getJMSType());
        Enumeration propertyNames = jmsRequest.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = propertyNames.nextElement().toString();
            headers.put(propertyName, jmsRequest.getObjectProperty(propertyName));
        }
        workContext.addHeader("sca4j.jms.inbound", headers);
    }

    protected void reportException(Exception e) {
        if (!this.runtimeLifecycle.isShutdown()) {
            this.template.monitor.jmsListenerError(this.template.jmsFactory.getDestination().toString(), e);
            this.exception = true;
        }
    }
}

