/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime.host.standalone;

import java.lang.reflect.Array;
import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.sca4j.binding.jms.common.TransactionType;
import org.sca4j.binding.jms.runtime.helper.JmsHelper;
import org.sca4j.binding.jms.runtime.host.standalone.ConsumerWorker;
import org.sca4j.binding.jms.runtime.host.standalone.ConsumerWorkerTemplate;
import org.sca4j.binding.jms.runtime.tx.JmsTransactionHandler;
import org.sca4j.binding.jms.runtime.tx.JtaTransactionHandler;
import org.sca4j.binding.jms.runtime.tx.TransactionHandler;
import org.sca4j.host.runtime.RuntimeLifecycle;
import org.sca4j.spi.invocation.Message;
import org.sca4j.spi.invocation.MessageImpl;
import org.sca4j.spi.invocation.WorkContext;

public class OneWayConsumer
extends ConsumerWorker {
    public OneWayConsumer(ConsumerWorkerTemplate template, RuntimeLifecycle runtimeLifecycle) {
        super(template, runtimeLifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        TransactionHandler transactionHandler;
        MessageProducer producer;
        MessageConsumer consumer;
        Session session;
        Connection connection;
        block14: {
            connection = null;
            session = null;
            consumer = null;
            producer = null;
            transactionHandler = null;
            if (!this.runtimeLifecycle.isShutdown()) break block14;
            JmsHelper.closeQuietly(producer);
            JmsHelper.closeQuietly(consumer);
            JmsHelper.closeQuietly(session);
            JmsHelper.closeQuietly(connection);
            return;
        }
        try {
            javax.jms.Message jmsRequest;
            if (this.exception) {
                this.exception = false;
                Thread.sleep(this.template.exceptionTimeout);
            }
            connection = this.template.jmsFactory.getConnection();
            session = this.template.jmsFactory.getSession(connection, this.template.transactionType);
            connection.start();
            transactionHandler = this.template.transactionType == TransactionType.GLOBAL ? new JtaTransactionHandler(this.template.transactionManager) : new JmsTransactionHandler(session);
            transactionHandler.begin();
            transactionHandler.enlist(session);
            consumer = this.template.metadata.selector != null ? session.createConsumer(this.template.jmsFactory.getDestination(), this.template.metadata.selector) : session.createConsumer(this.template.jmsFactory.getDestination());
            int batchSize = this.template.metadata.batched ? this.template.metadata.batchSize : 1;
            LinkedList<javax.jms.Message> jmsRequests = new LinkedList<javax.jms.Message>();
            for (int i = 0; i < batchSize && (jmsRequest = consumer.receive((long)this.template.pollingInterval)) != null; ++i) {
                jmsRequests.add(jmsRequest);
            }
            if (jmsRequests.size() > 0) {
                WorkContext workContext;
                if (!this.template.metadata.batched) {
                    Object payload = this.dataBinder.unmarshal((javax.jms.Message)jmsRequests.get(0), this.inputType);
                    workContext = new WorkContext();
                    this.copyHeaders((javax.jms.Message)jmsRequests.get(0), workContext);
                    MessageImpl sca4jRequest = new MessageImpl((Object)new Object[]{payload}, false, workContext);
                    this.invocationChain.getHeadInterceptor().invoke((Message)sca4jRequest);
                } else {
                    Object[] payload = (Object[])Array.newInstance(this.inputType.getComponentType(), jmsRequests.size());
                    workContext = new WorkContext();
                    for (int i = 0; i < payload.length; ++i) {
                        payload[i] = this.dataBinder.unmarshal((javax.jms.Message)jmsRequests.get(i), this.inputType);
                        this.copyHeaders((javax.jms.Message)jmsRequests.get(i), workContext);
                    }
                    MessageImpl sca4jRequest = new MessageImpl((Object)new Object[]{payload}, false, workContext);
                    this.invocationChain.getHeadInterceptor().invoke((Message)sca4jRequest);
                }
            }
            transactionHandler.delist(session, 0x4000000);
            transactionHandler.commit();
        }
        catch (Exception ex) {
            try {
                this.reportException(ex);
                try {
                    if (transactionHandler != null) {
                        transactionHandler.delist(session, 0x20000000);
                        transactionHandler.rollback();
                    }
                }
                catch (Exception e1) {
                    this.reportException(e1);
                }
            }
            catch (Throwable throwable) {
                JmsHelper.closeQuietly(producer);
                JmsHelper.closeQuietly(consumer);
                JmsHelper.closeQuietly(session);
                JmsHelper.closeQuietly(connection);
                throw throwable;
            }
            JmsHelper.closeQuietly(producer);
            JmsHelper.closeQuietly(consumer);
            JmsHelper.closeQuietly(session);
            JmsHelper.closeQuietly(connection);
        }
        JmsHelper.closeQuietly(producer);
        JmsHelper.closeQuietly(consumer);
        JmsHelper.closeQuietly(session);
        JmsHelper.closeQuietly(connection);
    }
}

