/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime.host.standalone;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.oasisopen.sca.annotation.Reference;
import org.sca4j.api.annotation.Monitor;
import org.sca4j.binding.jms.common.JmsBindingMetadata;
import org.sca4j.binding.jms.common.TransactionType;
import org.sca4j.binding.jms.runtime.JMSObjectFactory;
import org.sca4j.binding.jms.runtime.JMSRuntimeMonitor;
import org.sca4j.binding.jms.runtime.host.JmsHost;
import org.sca4j.binding.jms.runtime.host.standalone.ConsumerWorker;
import org.sca4j.binding.jms.runtime.host.standalone.ConsumerWorkerTemplate;
import org.sca4j.binding.jms.runtime.host.standalone.OneWayConsumer;
import org.sca4j.binding.jms.runtime.host.standalone.TwoWayConsumer;
import org.sca4j.host.runtime.RuntimeLifecycle;
import org.sca4j.host.work.DefaultPausableWork;
import org.sca4j.host.work.WorkScheduler;
import org.sca4j.spi.model.physical.PhysicalOperationPair;
import org.sca4j.spi.wire.Wire;

public class StandalonePullJmsHost
implements JmsHost {
    @Reference
    public WorkScheduler workScheduler;
    @Monitor
    public JMSRuntimeMonitor monitor;
    @Reference
    public TransactionManager transactionManager;
    @Reference
    public RuntimeLifecycle runtimeLifecycle;
    private Map<URI, List<ConsumerWorker>> consumerWorkerMap = new HashMap<URI, List<ConsumerWorker>>();

    @Override
    public void register(JMSObjectFactory jmsFactory, TransactionType transactionType, Wire wire, JmsBindingMetadata metadata, URI serviceUri) {
        ArrayList<TwoWayConsumer> consumerWorkers = new ArrayList<TwoWayConsumer>();
        ConsumerWorkerTemplate template = new ConsumerWorkerTemplate();
        template.transactionManager = this.transactionManager;
        template.transactionType = transactionType;
        template.jmsFactory = jmsFactory;
        template.pollingInterval = metadata.pollingInterval;
        template.exceptionTimeout = metadata.exceptionTimeout;
        template.monitor = this.monitor;
        template.metadata = metadata;
        template.wire = wire;
        String returnType = ((PhysicalOperationPair)wire.getInvocationChains().entrySet().iterator().next().getKey()).getTargetOperation().getReturnType();
        boolean twoWay = returnType != null && !"void".equalsIgnoreCase(returnType);
        for (int i = 0; i < metadata.consumerCount; ++i) {
            ConsumerWorker work = twoWay ? new TwoWayConsumer(template, this.runtimeLifecycle) : new OneWayConsumer(template, this.runtimeLifecycle);
            this.workScheduler.scheduleWork((DefaultPausableWork)work);
            consumerWorkers.add((TwoWayConsumer)work);
        }
        this.consumerWorkerMap.put(serviceUri, consumerWorkers);
    }
}

