/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime.host.standalone;

import javax.jms.Connection;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.sca4j.binding.jms.common.SCA4JJmsException;
import org.sca4j.binding.jms.common.TransactionType;
import org.sca4j.binding.jms.runtime.helper.JmsHelper;
import org.sca4j.binding.jms.runtime.host.standalone.ConsumerWorker;
import org.sca4j.binding.jms.runtime.host.standalone.ConsumerWorkerTemplate;
import org.sca4j.binding.jms.runtime.tx.JmsTransactionHandler;
import org.sca4j.binding.jms.runtime.tx.JtaTransactionHandler;
import org.sca4j.binding.jms.runtime.tx.TransactionHandler;
import org.sca4j.host.runtime.RuntimeLifecycle;
import org.sca4j.spi.invocation.Message;
import org.sca4j.spi.invocation.MessageImpl;
import org.sca4j.spi.invocation.WorkContext;
import org.sca4j.spi.model.physical.PhysicalOperationDefinition;
import org.sca4j.spi.model.physical.PhysicalOperationPair;
import org.sca4j.spi.wire.InvocationChain;

public class TwoWayConsumer
extends ConsumerWorker {
    private Class<?> outputType;

    public TwoWayConsumer(ConsumerWorkerTemplate template, RuntimeLifecycle runtimeLifecycle) {
        super(template, runtimeLifecycle);
        try {
            PhysicalOperationDefinition pod = ((PhysicalOperationPair)template.wire.getInvocationChains().entrySet().iterator().next().getKey()).getTargetOperation();
            this.invocationChain = (InvocationChain)template.wire.getInvocationChains().entrySet().iterator().next().getValue();
            String outputTypeName = pod.getReturnType();
            if (outputTypeName != null && outputTypeName != "void") {
                this.outputType = Class.forName(outputTypeName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new SCA4JJmsException("Unable to load operation types", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        TransactionHandler transactionHandler;
        MessageProducer producer;
        MessageConsumer consumer;
        Session session;
        Connection connection;
        block14: {
            connection = null;
            session = null;
            consumer = null;
            producer = null;
            transactionHandler = null;
            if (!this.runtimeLifecycle.isShutdown()) break block14;
            JmsHelper.closeQuietly(producer);
            JmsHelper.closeQuietly(consumer);
            JmsHelper.closeQuietly(session);
            JmsHelper.closeQuietly(connection);
            return;
        }
        try {
            if (this.exception) {
                this.exception = false;
                Thread.sleep(this.template.exceptionTimeout);
            }
            connection = this.template.jmsFactory.getConnection();
            session = this.template.jmsFactory.getSession(connection, this.template.transactionType);
            connection.start();
            transactionHandler = this.template.transactionType == TransactionType.GLOBAL ? new JtaTransactionHandler(this.template.transactionManager) : new JmsTransactionHandler(session);
            transactionHandler.begin();
            transactionHandler.enlist(session);
            consumer = this.template.metadata.selector != null ? session.createConsumer(this.template.jmsFactory.getDestination(), this.template.metadata.selector) : session.createConsumer(this.template.jmsFactory.getDestination());
            javax.jms.Message jmsRequest = consumer.receive((long)this.template.pollingInterval);
            if (jmsRequest != null) {
                Object payload = this.dataBinder.unmarshal(jmsRequest, this.inputType);
                WorkContext workContext = new WorkContext();
                this.copyHeaders(jmsRequest, workContext);
                MessageImpl sca4jRequest = new MessageImpl((Object)new Object[]{payload}, false, workContext);
                Message sca4jResponse = this.invocationChain.getHeadInterceptor().invoke((Message)sca4jRequest);
                javax.jms.Message jmsResponse = this.dataBinder.marshal(sca4jResponse.getBody(), this.outputType, session);
                switch (this.template.metadata.correlation) {
                    case messageID: {
                        jmsResponse.setJMSCorrelationID(jmsRequest.getJMSMessageID());
                        break;
                    }
                    case correlationID: {
                        jmsResponse.setJMSCorrelationID(jmsRequest.getJMSCorrelationID());
                    }
                }
                producer = session.createProducer(this.template.jmsFactory.getResponseDestination());
                producer.send(jmsResponse);
            }
            transactionHandler.delist(session, 0x4000000);
            transactionHandler.commit();
        }
        catch (Exception ex) {
            try {
                this.reportException(ex);
                try {
                    if (transactionHandler != null) {
                        transactionHandler.delist(session, 0x20000000);
                        transactionHandler.rollback();
                    }
                }
                catch (Exception e1) {
                    this.reportException(e1);
                }
            }
            catch (Throwable throwable) {
                JmsHelper.closeQuietly(producer);
                JmsHelper.closeQuietly(consumer);
                JmsHelper.closeQuietly(session);
                JmsHelper.closeQuietly(connection);
                throw throwable;
            }
            JmsHelper.closeQuietly(producer);
            JmsHelper.closeQuietly(consumer);
            JmsHelper.closeQuietly(session);
            JmsHelper.closeQuietly(connection);
        }
        JmsHelper.closeQuietly(producer);
        JmsHelper.closeQuietly(consumer);
        JmsHelper.closeQuietly(session);
        JmsHelper.closeQuietly(connection);
    }
}

