/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime.interceptor;

import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.sca4j.binding.jms.common.SCA4JJmsException;
import org.sca4j.binding.jms.runtime.JMSObjectFactory;
import org.sca4j.binding.jms.runtime.wireformat.DataBinder;
import org.sca4j.spi.invocation.WorkContext;
import org.sca4j.spi.model.physical.PhysicalOperationDefinition;
import org.sca4j.spi.model.physical.PhysicalOperationPair;
import org.sca4j.spi.wire.Interceptor;
import org.sca4j.spi.wire.Wire;

public abstract class AbstractInterceptor
implements Interceptor {
    private Interceptor next;
    protected final DataBinder dataBinder = new DataBinder();
    protected final JMSObjectFactory jmsFactory;
    protected final Class<?> inputType;

    public AbstractInterceptor(JMSObjectFactory jmsFactory, Wire wire) {
        try {
            PhysicalOperationDefinition pod = ((PhysicalOperationPair)wire.getInvocationChains().entrySet().iterator().next().getKey()).getTargetOperation();
            this.inputType = Class.forName((String)pod.getParameters().get(0));
            this.jmsFactory = jmsFactory;
        }
        catch (ClassNotFoundException e) {
            throw new SCA4JJmsException("Unable to load operation types", e);
        }
    }

    public final Interceptor getNext() {
        return this.next;
    }

    public final void setNext(Interceptor next) {
        this.next = next;
    }

    protected void copyHeaders(WorkContext workContext, Message jmsMessage) throws JMSException {
        Map headers = (Map)workContext.getHeader(Map.class, "sca4j.jms.outbound");
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                jmsMessage.setObjectProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }
}

