/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime.interceptor;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.sca4j.binding.jms.common.SCA4JJmsException;
import org.sca4j.binding.jms.common.TransactionType;
import org.sca4j.binding.jms.runtime.JMSObjectFactory;
import org.sca4j.binding.jms.runtime.helper.JmsHelper;
import org.sca4j.binding.jms.runtime.interceptor.AbstractInterceptor;
import org.sca4j.binding.jms.runtime.tx.JmsTransactionHandler;
import org.sca4j.binding.jms.runtime.tx.TransactionHandler;
import org.sca4j.spi.invocation.Message;
import org.sca4j.spi.invocation.MessageImpl;
import org.sca4j.spi.wire.Interceptor;
import org.sca4j.spi.wire.Wire;

public class OneWayLocalInterceptor
extends AbstractInterceptor
implements Interceptor {
    public OneWayLocalInterceptor(JMSObjectFactory jmsFactory, Wire wire) {
        super(jmsFactory, wire);
    }

    public Message invoke(Message sca4jRequest) {
        MessageImpl messageImpl;
        MessageImpl sca4jResponse = new MessageImpl();
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        MessageConsumer messageConsumer = null;
        TransactionHandler transactionHandler = null;
        try {
            connection = this.jmsFactory.getConnection();
            session = this.jmsFactory.getSession(connection, TransactionType.LOCAL);
            connection.start();
            transactionHandler = new JmsTransactionHandler(session);
            messageProducer = session.createProducer(this.jmsFactory.getDestination());
            Object body = ((Object[])sca4jRequest.getBody())[0];
            if (body.getClass().isArray()) {
                for (Object component : (Object[])body) {
                    javax.jms.Message jmsRequest = this.dataBinder.marshal(component, this.inputType, session);
                    this.copyHeaders(sca4jRequest.getWorkContext(), jmsRequest);
                    messageProducer.send(jmsRequest);
                }
            } else {
                javax.jms.Message jmsRequest = this.dataBinder.marshal(body, this.inputType, session);
                this.copyHeaders(sca4jRequest.getWorkContext(), jmsRequest);
                messageProducer.send(jmsRequest);
            }
            transactionHandler.commit();
            messageImpl = sca4jResponse;
        }
        catch (JMSException ex) {
            try {
                transactionHandler.rollback();
                throw new SCA4JJmsException("Unable to receive response", ex);
            }
            catch (Throwable throwable) {
                JmsHelper.closeQuietly(messageProducer);
                JmsHelper.closeQuietly(messageConsumer);
                JmsHelper.closeQuietly(session);
                JmsHelper.closeQuietly(connection);
                throw throwable;
            }
        }
        JmsHelper.closeQuietly(messageProducer);
        JmsHelper.closeQuietly(messageConsumer);
        JmsHelper.closeQuietly(session);
        JmsHelper.closeQuietly(connection);
        return messageImpl;
    }
}

