/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime.interceptor;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.sca4j.binding.jms.common.Correlation;
import org.sca4j.binding.jms.common.SCA4JJmsException;
import org.sca4j.binding.jms.common.TransactionType;
import org.sca4j.binding.jms.runtime.JMSObjectFactory;
import org.sca4j.binding.jms.runtime.helper.JmsHelper;
import org.sca4j.binding.jms.runtime.interceptor.AbstractInterceptor;
import org.sca4j.binding.jms.runtime.tx.JmsTransactionHandler;
import org.sca4j.binding.jms.runtime.tx.TransactionHandler;
import org.sca4j.spi.invocation.Message;
import org.sca4j.spi.invocation.MessageImpl;
import org.sca4j.spi.model.physical.PhysicalOperationDefinition;
import org.sca4j.spi.model.physical.PhysicalOperationPair;
import org.sca4j.spi.wire.Interceptor;
import org.sca4j.spi.wire.Wire;

public class TwoWayLocalInterceptor
extends AbstractInterceptor
implements Interceptor {
    private Correlation correlation;
    private Class<?> outputType;

    public TwoWayLocalInterceptor(JMSObjectFactory jmsFactory, Correlation correlation, Wire wire) {
        super(jmsFactory, wire);
        try {
            PhysicalOperationDefinition pod = ((PhysicalOperationPair)wire.getInvocationChains().entrySet().iterator().next().getKey()).getTargetOperation();
            this.outputType = Class.forName(pod.getReturnType());
            this.correlation = correlation;
        }
        catch (ClassNotFoundException e) {
            throw new SCA4JJmsException("Unable to load operation types", e);
        }
    }

    public Message invoke(Message sca4jRequest) {
        MessageImpl messageImpl;
        MessageImpl sca4jResponse = new MessageImpl();
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        MessageConsumer messageConsumer = null;
        TransactionHandler transactionHandler = null;
        try {
            connection = this.jmsFactory.getConnection();
            session = this.jmsFactory.getSession(connection, TransactionType.LOCAL);
            connection.start();
            transactionHandler = new JmsTransactionHandler(session);
            messageProducer = session.createProducer(this.jmsFactory.getDestination());
            Object[] payload = (Object[])sca4jRequest.getBody();
            javax.jms.Message jmsRequest = this.dataBinder.marshal(payload[0], this.inputType, session);
            this.copyHeaders(sca4jRequest.getWorkContext(), jmsRequest);
            messageProducer.send(jmsRequest);
            transactionHandler.commit();
            String selector = null;
            switch (this.correlation) {
                case messageID: {
                    selector = "JMSCorrelationID = '" + jmsRequest.getJMSMessageID() + "'";
                    break;
                }
                case correlationID: {
                    selector = "JMSCorrelationID = '" + jmsRequest.getJMSCorrelationID() + "'";
                }
            }
            messageConsumer = session.createConsumer(this.jmsFactory.getResponseDestination(), selector);
            transactionHandler.begin();
            javax.jms.Message jmsResponse = messageConsumer.receive();
            sca4jResponse.setBody(this.dataBinder.unmarshal(jmsResponse, this.outputType));
            transactionHandler.commit();
            messageImpl = sca4jResponse;
        }
        catch (JMSException ex) {
            try {
                transactionHandler.rollback();
                throw new SCA4JJmsException("Unable to receive response", ex);
            }
            catch (Throwable throwable) {
                JmsHelper.closeQuietly(messageProducer);
                JmsHelper.closeQuietly(messageConsumer);
                JmsHelper.closeQuietly(session);
                JmsHelper.closeQuietly(connection);
                throw throwable;
            }
        }
        JmsHelper.closeQuietly(messageProducer);
        JmsHelper.closeQuietly(messageConsumer);
        JmsHelper.closeQuietly(session);
        JmsHelper.closeQuietly(connection);
        return messageImpl;
    }
}

