/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime.tx;

import javax.jms.Session;
import javax.jms.XASession;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.sca4j.binding.jms.runtime.tx.JmsTxException;
import org.sca4j.binding.jms.runtime.tx.TransactionHandler;

public class JtaTransactionHandler
implements TransactionHandler {
    private TransactionManager transactionManager;

    public JtaTransactionHandler(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (Exception e) {
            throw new JmsTxException(e);
        }
    }

    @Override
    public void enlist(Session session) throws JmsTxException {
        try {
            XASession xaSession = (XASession)session;
            XAResource xaResource = xaSession.getXAResource();
            this.transactionManager.getTransaction().enlistResource(xaResource);
        }
        catch (Exception e) {
            throw new JmsTxException(e);
        }
    }

    @Override
    public void delist(Session session, int status) throws JmsTxException {
        try {
            XASession xaSession = (XASession)session;
            XAResource xaResource = xaSession.getXAResource();
            this.transactionManager.getTransaction().delistResource(xaResource, status);
        }
        catch (Exception e) {
            throw new JmsTxException(e);
        }
    }

    @Override
    public void commit() throws JmsTxException {
        try {
            this.transactionManager.commit();
        }
        catch (Exception e) {
            throw new JmsTxException(e);
        }
    }

    @Override
    public void resume(Transaction transaction) throws JmsTxException {
        try {
            this.transactionManager.resume(transaction);
        }
        catch (Exception e) {
            throw new JmsTxException(e);
        }
    }

    @Override
    public void suspend() throws JmsTxException {
        try {
            this.transactionManager.suspend();
        }
        catch (Exception e) {
            throw new JmsTxException(e);
        }
    }

    @Override
    public void begin() throws JmsTxException {
        try {
            this.transactionManager.begin();
        }
        catch (Exception e) {
            throw new JmsTxException(e);
        }
    }

    @Override
    public void rollback() throws JmsTxException {
        try {
            this.transactionManager.rollback();
        }
        catch (Exception e) {
            throw new JmsTxException(e);
        }
    }
}

