/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.jms.runtime.wireformat;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import org.sca4j.binding.jms.common.SCA4JJmsException;

public class DataBinder {
    public Object unmarshal(Message jmsMessage, Class<?> type) {
        try {
            if (type.isArray()) {
                type = type.getComponentType();
            }
            if (String.class.equals(type)) {
                return ((TextMessage)jmsMessage).getText();
            }
            if (Message.class.isAssignableFrom(type)) {
                return jmsMessage;
            }
            if (type.getAnnotation(XmlRootElement.class) != null) {
                String text = ((TextMessage)jmsMessage).getText();
                return JAXBContext.newInstance((Class[])new Class[]{type}).createUnmarshaller().unmarshal((Reader)new StringReader(text));
            }
            if (Object.class.equals(type)) {
                return ((TextMessage)jmsMessage).getText();
            }
            throw new IllegalArgumentException("Type not supported " + type);
        }
        catch (JMSException e) {
            throw new SCA4JJmsException("Unable to unmarshal type " + type, e);
        }
        catch (JAXBException e) {
            throw new SCA4JJmsException("Unable to unmarshal type " + type, e);
        }
    }

    public Message marshal(Object value, Class<?> type, Session session) {
        try {
            if (type.isArray()) {
                type = type.getComponentType();
            }
            if (String.class.equals(type)) {
                return session.createTextMessage(value.toString());
            }
            if (Message.class.isAssignableFrom(type)) {
                return (Message)value;
            }
            if (type.getAnnotation(XmlRootElement.class) != null) {
                StringWriter stringWriter = new StringWriter();
                JAXBContext.newInstance((Class[])new Class[]{type}).createMarshaller().marshal(value, (Writer)stringWriter);
                return session.createTextMessage(stringWriter.toString());
            }
            if (Object.class.equals(type)) {
                return session.createTextMessage(value.toString());
            }
            throw new IllegalArgumentException("Type not supported " + type);
        }
        catch (JMSException e) {
            throw new SCA4JJmsException("Unable to unmarshal type " + type, e);
        }
        catch (JAXBException e) {
            throw new SCA4JJmsException("Unable to unmarshal type " + type, e);
        }
    }
}

