/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.ws.axis2.runtime.config;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Flow;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;
import org.sca4j.binding.ws.axis2.runtime.config.SCA4JConfigurator;
import org.sca4j.binding.ws.axis2.runtime.config.SCA4JThreadFactory;
import org.sca4j.host.work.WorkScheduler;

@EagerInit
public class SCA4JConfiguratorImpl
implements SCA4JConfigurator {
    private WorkScheduler scheduler;
    private ConfigurationContext configurationContext;
    private String servicePath = "axis2";
    private Map<String, AxisModule> modules = new HashMap<String, AxisModule>();
    private String chunkTransferEncoding = "true";
    private String cacheLargeAttachements = "true";
    private String cacheThreshold = "100000";

    public SCA4JConfiguratorImpl(@Reference WorkScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Property(required=false)
    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    @Property(required=false)
    public void setCacheLargeAttachements(String val) {
        this.cacheLargeAttachements = val;
    }

    @Property(required=false)
    public void setCacheThreshold(String threshold) {
        this.cacheThreshold = threshold;
    }

    @Property(required=false)
    public void setChunkTransferEncoding(String val) {
        this.chunkTransferEncoding = val;
    }

    @Init
    public void start() throws Exception {
        this.configurationContext = ConfigurationContextFactory.createDefaultConfigurationContext();
        this.configurationContext.setServicePath(this.servicePath);
        SCA4JThreadFactory factory = new SCA4JThreadFactory(this.scheduler);
        this.configurationContext.setThreadPool((ThreadFactory)factory);
        this.configurationContext.setProperty("__CHUNKED__", (Object)this.chunkTransferEncoding);
        this.configurationContext.setProperty("cacheAttachments", (Object)this.cacheLargeAttachements);
        this.configurationContext.setProperty("sizeThreshold", (Object)this.cacheThreshold);
        File dir = new File(System.getProperty("java.io.tmpdir"), ".sca4j");
        dir.mkdir();
        File attachementDir = new File(dir, "axis2");
        attachementDir.mkdir();
        this.configurationContext.setProperty("attachmentDIR", (Object)attachementDir.toString());
        AxisConfiguration axisConfiguration = this.configurationContext.getAxisConfiguration();
        ClassLoader classLoader = this.getClass().getClassLoader();
        Enumeration<URL> modules = classLoader.getResources("META-INF/module.xml");
        while (modules.hasMoreElements()) {
            AxisModule axisModule = new AxisModule();
            axisModule.setParent(axisConfiguration);
            axisModule.setModuleClassLoader(classLoader);
            InputStream moduleStream = modules.nextElement().openStream();
            ModuleBuilder moduleBuilder = new ModuleBuilder(moduleStream, axisModule, axisConfiguration);
            moduleBuilder.populateModule();
            this.addNewModule(axisModule, axisConfiguration);
        }
        Utils.calculateDefaultModuleVersion((HashMap)axisConfiguration.getModules(), (AxisConfiguration)axisConfiguration);
        axisConfiguration.validateSystemPredefinedPhases();
    }

    @Override
    public AxisModule getModule(String name) {
        return this.modules.get(name);
    }

    @Override
    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    private void addNewModule(AxisModule axisModule, AxisConfiguration axisConfiguration) throws AxisFault {
        ClassLoader moduleClassLoader = axisModule.getModuleClassLoader();
        this.addFlowHandlers(axisModule.getInFlow(), moduleClassLoader);
        this.addFlowHandlers(axisModule.getOutFlow(), moduleClassLoader);
        this.addFlowHandlers(axisModule.getFaultInFlow(), moduleClassLoader);
        this.addFlowHandlers(axisModule.getFaultOutFlow(), moduleClassLoader);
        axisConfiguration.addModule(axisModule);
        this.modules.put(axisModule.getName(), axisModule);
    }

    private void addFlowHandlers(Flow flow, ClassLoader moduleClassLoader) throws AxisFault {
        if (flow != null) {
            org.apache.axis2.deployment.util.Utils.addFlowHandlers((Flow)flow, (ClassLoader)moduleClassLoader);
        }
    }
}

