/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.ws.axis2.runtime.jaxb;

import java.lang.reflect.Method;
import javax.xml.bind.JAXBContext;
import javax.xml.ws.WebFault;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.sca4j.binding.ws.axis2.runtime.jaxb.Jaxb2OMElement;

public class FaultData {
    private final Object webFault;
    private final OMElement faultDetail;

    public FaultData(Object webFault, JAXBContext jaxbContext) {
        this.webFault = webFault;
        this.faultDetail = this.buildFaultElement(webFault, jaxbContext);
    }

    public AxisFault asAxisFault() {
        AxisFault fault = AxisFault.makeFault((Throwable)((Throwable)this.webFault));
        if (this.faultDetail != null) {
            fault.setDetail(this.faultDetail);
        }
        return fault;
    }

    private OMElement buildFaultElement(Object webFault, JAXBContext jaxbContext) {
        OMElement result = null;
        Object faultDetail = this.getFault(webFault);
        if (faultDetail != null) {
            result = new Jaxb2OMElement(jaxbContext).transform(faultDetail, null);
        }
        return result;
    }

    private Object getFault(Object webFault) {
        WebFault annotation = webFault.getClass().getAnnotation(WebFault.class);
        if (annotation == null) {
            if (webFault instanceof RuntimeException) {
                throw (RuntimeException)webFault;
            }
            if (webFault instanceof Exception) {
                throw new AssertionError(webFault);
            }
            if (webFault instanceof Error) {
                throw (Error)webFault;
            }
        }
        try {
            Method getFaultInfo = webFault.getClass().getMethod("getFaultInfo", new Class[0]);
            return getFaultInfo.invoke(webFault, new Object[0]);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

