/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.ws.axis2.runtime.jaxb;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.axiom.om.OMElement;
import org.sca4j.binding.ws.axis2.runtime.jaxb.FaultData;
import org.sca4j.binding.ws.axis2.runtime.jaxb.Jaxb2OMElement;
import org.sca4j.binding.ws.axis2.runtime.jaxb.JaxbMessageContentBuilder;
import org.sca4j.binding.ws.axis2.runtime.jaxb.MessageData;
import org.sca4j.binding.ws.axis2.runtime.jaxb.OMElement2Jaxb;
import org.sca4j.spi.invocation.Message;
import org.sca4j.spi.wire.Interceptor;
import org.sca4j.transform.TransformContext;

public class JaxbInterceptor
implements Interceptor {
    private Interceptor next;
    private final OMElement2Jaxb inTransformer;
    private final Jaxb2OMElement outTransformer;
    private final boolean service;
    private final Map<Class<?>, Constructor<?>> faultMapping;
    private final Method interceptedMethod;
    private final boolean jaxbBinding;
    private final JAXBContext jaxbContext;

    public JaxbInterceptor(JAXBContext jaxbContext, boolean service, Map<Class<?>, Constructor<?>> faultMapping, Method interceptedMethod, boolean jaxbBinding) throws JAXBException {
        this.jaxbContext = jaxbContext;
        this.service = service;
        this.faultMapping = faultMapping;
        this.interceptedMethod = interceptedMethod;
        this.jaxbBinding = jaxbBinding;
        this.inTransformer = new OMElement2Jaxb(jaxbContext);
        this.outTransformer = new Jaxb2OMElement(jaxbContext);
    }

    public Interceptor getNext() {
        return this.next;
    }

    public Message invoke(Message message) {
        if (!this.jaxbBinding) {
            return this.next.invoke(message);
        }
        return this.service ? this.interceptService(message) : this.interceptReference(message);
    }

    private Message interceptService(Message message) {
        Object result;
        Message response;
        Object[] payload = (Object[])message.getBody();
        if (payload != null && payload.length > 0) {
            OMElement omElement = (OMElement)payload[0];
            Object jaxbObject = this.inTransformer.transform(omElement, (TransformContext)null);
            message.setBody((Object)new Object[]{jaxbObject});
        }
        if ((response = this.next.invoke(message)).isFault()) {
            Object webFault = response.getBody();
            result = new FaultData(webFault, this.jaxbContext);
            response.setBodyWithFault(result);
        } else {
            result = response.getBody();
            if (result != null) {
                OMElement omElement = this.outTransformer.transform(result, null);
                response.setBody((Object)omElement);
            }
        }
        return response;
    }

    private Message interceptReference(Message message) {
        Message response;
        Object result;
        Object[] payload = (Object[])message.getBody();
        if (payload != null && payload.length > 0) {
            JaxbMessageContentBuilder contentBuilder = new JaxbMessageContentBuilder(this.interceptedMethod, this.jaxbContext, payload);
            List<MessageData> messageContent = contentBuilder.build();
            message.setBody((Object)messageContent.toArray());
        }
        if ((result = (response = this.next.invoke(message)).getBody()) != null) {
            OMElement omElement = (OMElement)result;
            Object jaxbObject = this.inTransformer.transform(omElement, (TransformContext)null);
            Constructor<?> faultConstructor = this.faultMapping.get(jaxbObject.getClass());
            if (faultConstructor != null) {
                try {
                    Object fault = faultConstructor.newInstance(null, jaxbObject);
                    response.setBodyWithFault(fault);
                }
                catch (InstantiationException e) {
                    throw new AssertionError();
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError();
                }
                catch (InvocationTargetException e) {
                    throw new AssertionError();
                }
            } else {
                response.setBody(jaxbObject);
            }
        }
        return response;
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }
}

