/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.ws.axis2.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.ws.WebFault;

public class JaxbMethodInfo {
    private List<Class<?>> parameterTypes = new LinkedList();
    private Class<?> returnType;
    private List<Class<?>> faultInfos = new LinkedList();
    private List<Class<?>> faults = new LinkedList();
    private Map<Class<?>, Constructor<?>> faultConstructors = new HashMap();

    public JaxbMethodInfo(Method method) {
        try {
            for (Class<?> paramType : method.getParameterTypes()) {
                if (paramType.getAnnotation(XmlRootElement.class) == null) continue;
                this.parameterTypes.add(paramType);
            }
            Class<?> returnType = method.getReturnType();
            if (returnType.getAnnotation(XmlRootElement.class) != null) {
                this.returnType = returnType;
            }
            for (Class<?> fault : method.getExceptionTypes()) {
                if (fault.getAnnotation(WebFault.class) == null) continue;
                this.faultInfos.add(fault.getMethod("getFaultInfo", new Class[0]).getReturnType());
                this.faults.add(fault);
            }
            for (Class<?> fault : this.faults) {
                Constructor<?> constructor = fault.getConstructor(String.class, fault.getMethod("getFaultInfo", new Class[0]).getReturnType());
                this.faultConstructors.put(fault.getMethod("getFaultInfo", new Class[0]).getReturnType(), constructor);
            }
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public List<Class<?>> getJaxbClasses() {
        LinkedList classes = new LinkedList();
        classes.addAll(this.parameterTypes);
        classes.addAll(this.faultInfos);
        if (this.returnType != null) {
            classes.add(this.returnType);
        }
        return classes;
    }

    public Map<Class<?>, Constructor<?>> getFaultConstructors() {
        return this.faultConstructors;
    }
}

