/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.ws.axis2.runtime;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;
import org.sca4j.api.annotation.Monitor;
import org.sca4j.binding.ws.axis2.provision.Axis2WireSourceDefinition;
import org.sca4j.binding.ws.axis2.provision.AxisPolicy;
import org.sca4j.binding.ws.axis2.runtime.Axis2ServiceProvisioner;
import org.sca4j.binding.ws.axis2.runtime.InOnlyServiceProxy;
import org.sca4j.binding.ws.axis2.runtime.InOutServiceProxy;
import org.sca4j.binding.ws.axis2.runtime.ServiceProvisionerMonitor;
import org.sca4j.binding.ws.axis2.runtime.config.SCA4JConfigurator;
import org.sca4j.binding.ws.axis2.runtime.policy.PolicyApplier;
import org.sca4j.binding.ws.axis2.runtime.servlet.SCA4JAxisServlet;
import org.sca4j.host.runtime.HostInfo;
import org.sca4j.spi.builder.WiringException;
import org.sca4j.spi.host.ServletHost;
import org.sca4j.spi.model.physical.PhysicalOperationPair;
import org.sca4j.spi.wire.InvocationChain;
import org.sca4j.spi.wire.Wire;
import org.w3c.dom.Element;

@EagerInit
public class Axis2ServiceProvisionerImpl
implements Axis2ServiceProvisioner {
    private final ServletHost servletHost;
    private final PolicyApplier policyApplier;
    private final SCA4JConfigurator f3Configurator;
    private ServiceProvisionerMonitor monitor;
    private ConfigurationContext configurationContext;
    private String servicePath = "axis2";
    private HostInfo hostInfo;

    public Axis2ServiceProvisionerImpl(@Reference(required=false) ServletHost servletHost, @Reference PolicyApplier policyApplier, @Reference SCA4JConfigurator f3Configurator, @Monitor ServiceProvisionerMonitor monitor, @Reference HostInfo hostInfo) {
        if (servletHost == null) {
            throw new AssertionError((Object)"Please configure a servlet host");
        }
        this.servletHost = servletHost;
        this.policyApplier = policyApplier;
        this.f3Configurator = f3Configurator;
        this.monitor = monitor;
        this.hostInfo = hostInfo;
    }

    @Property(required=false)
    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    @Init
    public void start() throws Exception {
        this.configurationContext = this.f3Configurator.getConfigurationContext();
        SCA4JAxisServlet axisServlet = new SCA4JAxisServlet(this.configurationContext);
        this.servletHost.registerMapping("/" + this.servicePath + "/*", (Servlet)axisServlet);
        this.monitor.extensionStarted();
    }

    @Override
    public void provision(Axis2WireSourceDefinition pwsd, Wire wire) throws WiringException {
        try {
            String uri = pwsd.getUri().toASCIIString();
            URI classLoaderUri = pwsd.getClassLoaderId();
            String serviceClass = pwsd.getServiceInterface();
            ClassLoader classLoader = this.getClass().getClassLoader();
            AxisService axisService = new AxisService();
            axisService.setName(uri);
            axisService.setDocumentation("SCA4J enabled axis service");
            axisService.setClientSide(false);
            axisService.setClassLoader(classLoader);
            axisService.setEndpointURL(uri);
            Parameter interfaceParameter = new Parameter("ServiceClass", (Object)serviceClass);
            axisService.addParameter(interfaceParameter);
            this.setMessageReceivers(wire, axisService);
            axisService.setName(uri);
            this.configurationContext.getAxisConfiguration().addService(axisService);
            this.applyPolicies(pwsd, axisService);
            this.monitor.endpointProvisioned("/" + this.servicePath + "/" + uri);
        }
        catch (Exception e) {
            throw new WiringException((Throwable)e);
        }
    }

    private void applyPolicies(Axis2WireSourceDefinition pwsd, AxisService axisService) throws WiringException, AxisFault {
        if ("true".equals(this.hostInfo.getProperty("axis2.policy.disable", "false"))) {
            return;
        }
        Iterator i = axisService.getOperations();
        while (i.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)i.next();
            String operation = axisOperation.getName().getLocalPart();
            Set<AxisPolicy> policies = pwsd.getPolicies(operation);
            if (policies == null || policies.size() == 0) continue;
            AxisOperation axisDescription = axisOperation;
            for (AxisPolicy axisPolicy : policies) {
                String message = axisPolicy.getMessage();
                String module = axisPolicy.getModule();
                Element opaquePolicy = axisPolicy.getOpaquePolicy();
                AxisModule axisModule = this.f3Configurator.getModule(module);
                axisOperation.addModule(axisModule.getName());
                axisOperation.engageModule(axisModule);
                if (message != null) {
                    axisDescription = axisOperation.getMessage(message);
                }
                if (opaquePolicy == null) continue;
                this.policyApplier.applyPolicy((AxisDescription)axisDescription, opaquePolicy);
            }
        }
    }

    private void setMessageReceivers(Wire wire, AxisService axisService) throws Exception {
        HashMap interceptors = new HashMap();
        for (Map.Entry entry : wire.getInvocationChains().entrySet()) {
            interceptors.put(((PhysicalOperationPair)entry.getKey()).getSourceOperation().getName(), entry.getValue());
        }
        Utils.fillAxisService((AxisService)axisService, (AxisConfiguration)this.configurationContext.getAxisConfiguration(), null, null);
        Iterator i = axisService.getOperations();
        while (i.hasNext()) {
            AxisOperation axisOp = (AxisOperation)i.next();
            InvocationChain invocationChain = (InvocationChain)interceptors.get(axisOp.getName().getLocalPart());
            Object messageReceiver = null;
            messageReceiver = "http://www.w3.org/ns/wsdl/in-only".equals(axisOp.getMessageExchangePattern()) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(axisOp.getMessageExchangePattern()) ? new InOnlyServiceProxy(invocationChain) : new InOutServiceProxy(invocationChain);
            axisOp.setMessageReceiver((MessageReceiver)messageReceiver);
        }
    }
}

