/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.ws.axis2.runtime;

import java.net.ConnectException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.oasisopen.sca.ServiceUnavailableException;
import org.sca4j.binding.ws.axis2.provision.AxisPolicy;
import org.sca4j.binding.ws.axis2.runtime.Axis2MessageContent;
import org.sca4j.binding.ws.axis2.runtime.config.SCA4JConfigurator;
import org.sca4j.binding.ws.axis2.runtime.policy.PolicyApplier;
import org.sca4j.spi.invocation.Message;
import org.sca4j.spi.invocation.MessageImpl;
import org.sca4j.spi.wire.Interceptor;

public class Axis2TargetInterceptor
implements Interceptor {
    private Interceptor next;
    private final List<String> endpointUris;
    private final String operation;
    private final Set<AxisPolicy> policies;
    private final Map<String, String> operationInfo;
    private final Map<String, String> config;
    private final SCA4JConfigurator f3Configurator;
    private final PolicyApplier policyApplier;
    private final AxisService axisService;

    public Axis2TargetInterceptor(List<String> endpointUris, String operation, Set<AxisPolicy> policies, Map<String, String> operationInfo, Map<String, String> config, SCA4JConfigurator f3Configurator, PolicyApplier policyApplier, AxisService axisService) {
        this.operation = operation;
        this.endpointUris = endpointUris;
        this.policies = policies;
        this.f3Configurator = f3Configurator;
        this.policyApplier = policyApplier;
        this.operationInfo = operationInfo;
        this.config = config;
        this.axisService = axisService;
    }

    public Interceptor getNext() {
        return this.next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(Message msg) {
        Random random = new Random();
        LinkedList<String> failedUris = new LinkedList<String>();
        String endpointUri = this.getEndpointUri(random, failedUris);
        Object[] payload = (Object[])msg.getBody();
        Axis2MessageContent messageContent = new Axis2MessageContent(payload);
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCl = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            ServiceClient sender = new ServiceClient(this.f3Configurator.getConfigurationContext(), null);
            sender.setOptions(this.buildOptions(endpointUri));
            sender.getOptions().setTimeOutInMilliSeconds(0L);
            this.applyPolicies(sender, this.operation);
            for (OMElement header : messageContent.getHeaders()) {
                sender.addHeader(header);
            }
            AxisOperation axisOperation = this.getAxisOperation(this.axisService, this.operation);
            MessageImpl ret = new MessageImpl();
            if ("http://www.w3.org/ns/wsdl/out-only".equals(axisOperation.getMessageExchangePattern()) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(axisOperation.getMessageExchangePattern())) {
                try {
                    sender.sendRobust(messageContent.getBody());
                }
                catch (AxisFault e) {
                    if (e.getCause() instanceof ConnectException) {
                        throw e;
                    }
                    ret.setBodyWithFault((Object)e.getDetail());
                }
            } else {
                OMElement result = sender.sendReceive(messageContent.getBody());
                if (result instanceof Throwable) {
                    ret.setBodyWithFault((Object)result);
                } else {
                    ret.setBody((Object)result);
                }
            }
            MessageImpl messageImpl = ret;
            return messageImpl;
        }
        catch (AxisFault e) {
            Message message = this.handleFault(msg, endpointUri, e, random, failedUris);
            return message;
        }
        finally {
            currentThread.setContextClassLoader(oldCl);
        }
    }

    private Options buildOptions(String endpointUri) {
        Options options = new Options();
        options.setTo(new EndpointReference(endpointUri));
        options.setTransportInProtocol("http");
        options.setProperty("enableMTOM", (Object)"true");
        options.setProperty("__CHUNKED__", (Object)"false");
        this.applyOperationInfo(options);
        this.applyConfig(options);
        return options;
    }

    private Message handleFault(Message msg, String endpointUri, AxisFault e, Random random, List<String> failedUris) {
        SOAPFaultDetail element;
        Throwable cause = e.getCause();
        if (cause instanceof ConnectException) {
            failedUris.add(endpointUri);
            if (failedUris.size() != this.endpointUris.size()) {
                return this.invoke(msg);
            }
        }
        if ((element = e.getFaultDetailElement()) == null) {
            throw new ServiceUnavailableException("Service fault was: \n" + (Object)((Object)e) + "\n\n", (Throwable)e);
        }
        OMNode child = element.getFirstOMChild();
        if (child == null) {
            throw new ServiceUnavailableException("Service fault was: \n" + (Object)((Object)e) + "\n\n", (Throwable)e);
        }
        throw new ServiceUnavailableException("Service fault was: \n" + child + "\n\n", (Throwable)e);
    }

    private String getEndpointUri(Random random, List<String> failedUris) {
        int index = random.nextInt(this.endpointUris.size());
        String endpointUri = this.endpointUris.get(index);
        if (failedUris.contains(endpointUri)) {
            endpointUri = this.getEndpointUri(random, failedUris);
        }
        return endpointUri;
    }

    private void applyOperationInfo(Options options) {
        String soapActionInfo;
        String soapAction = "urn:" + this.operation;
        if (this.operationInfo != null && (soapActionInfo = this.operationInfo.get("soapAction")) != null) {
            soapAction = soapActionInfo;
        }
        options.setAction(soapAction);
    }

    private void applyConfig(Options options) {
        boolean mtomEnabled;
        if (this.config != null && !(mtomEnabled = this.config.get("enableMTOM").equalsIgnoreCase("true"))) {
            options.setProperty("enableMTOM", (Object)"false");
            return;
        }
        options.setProperty("enableMTOM", (Object)"true");
    }

    private void applyPolicies(ServiceClient sender, String operation) throws AxisFault {
        if (this.policies == null) {
            return;
        }
        AxisService axisService = sender.getAxisService();
        AxisOperation axisOperation = axisService.getOperationBySOAPAction("urn:" + operation);
        if (axisOperation == null) {
            axisOperation = axisService.getOperation(ServiceClient.ANON_OUT_IN_OP);
        }
        AxisOperation axisDescription = axisOperation;
        for (AxisPolicy policy : this.policies) {
            String moduleName = policy.getModule();
            String message = policy.getMessage();
            AxisModule axisModule = this.f3Configurator.getModule(moduleName);
            axisOperation.addModule(axisModule.getName());
            axisOperation.engageModule(axisModule);
            if (message != null) {
                axisDescription = axisOperation.getMessage(message);
            }
            if (policy.getOpaquePolicy() == null) continue;
            this.policyApplier.applyPolicy((AxisDescription)axisDescription, policy.getOpaquePolicy());
        }
    }

    private AxisOperation getAxisOperation(AxisService axisService, String opName) {
        OutInAxisOperation axisOperation = new OutInAxisOperation();
        if (axisService != null) {
            Iterator i = axisService.getOperations();
            while (i.hasNext()) {
                AxisOperation axisOp = (AxisOperation)i.next();
                if (!axisOp.getName().getLocalPart().equals(opName)) continue;
                axisOperation = axisOp;
                break;
            }
        }
        return axisOperation;
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }
}

