/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.ws.axis2.runtime;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.description.AxisService;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;
import org.sca4j.binding.ws.axis2.provision.Axis2WireTargetDefinition;
import org.sca4j.binding.ws.axis2.provision.AxisPolicy;
import org.sca4j.binding.ws.axis2.runtime.Axis2TargetInterceptor;
import org.sca4j.binding.ws.axis2.runtime.config.SCA4JConfigurator;
import org.sca4j.binding.ws.axis2.runtime.policy.PolicyApplier;
import org.sca4j.spi.ObjectFactory;
import org.sca4j.spi.builder.WiringException;
import org.sca4j.spi.builder.component.TargetWireAttacher;
import org.sca4j.spi.model.physical.PhysicalOperationPair;
import org.sca4j.spi.model.physical.PhysicalWireSourceDefinition;
import org.sca4j.spi.wire.Interceptor;
import org.sca4j.spi.wire.InvocationChain;
import org.sca4j.spi.wire.Wire;

@EagerInit
public class Axis2TargetWireAttacher
implements TargetWireAttacher<Axis2WireTargetDefinition> {
    private final PolicyApplier policyApplier;
    private final SCA4JConfigurator f3Configurator;

    public Axis2TargetWireAttacher(@Reference PolicyApplier policyApplier, @Reference SCA4JConfigurator f3Configurator) {
        this.policyApplier = policyApplier;
        this.f3Configurator = f3Configurator;
    }

    public void attachToTarget(PhysicalWireSourceDefinition source, Axis2WireTargetDefinition target, Wire wire) throws WiringException {
        try {
            LinkedList<String> endpointUris = new LinkedList<String>();
            String endpointUri = URLDecoder.decode(target.getUri().toASCIIString(), "UTF-8");
            StringTokenizer tok = new StringTokenizer(endpointUri);
            while (tok.hasMoreElements()) {
                endpointUris.add(tok.nextToken().trim());
            }
            AxisService axisService = this.createAxisClientService(target);
            for (Map.Entry entry : wire.getInvocationChains().entrySet()) {
                String operation = ((PhysicalOperationPair)entry.getKey()).getSourceOperation().getName();
                Set<AxisPolicy> policies = target.getPolicies(operation);
                Map<String, String> opInfo = target.getOperationInfo() != null ? target.getOperationInfo().get(operation) : null;
                Axis2TargetInterceptor interceptor = new Axis2TargetInterceptor(endpointUris, operation, policies, opInfo, target.getConfig(), this.f3Configurator, this.policyApplier, axisService);
                ((InvocationChain)entry.getValue()).addInterceptor((Interceptor)interceptor);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new WiringException((Throwable)e);
        }
    }

    public ObjectFactory<?> createObjectFactory(Axis2WireTargetDefinition target) throws WiringException {
        throw new AssertionError();
    }

    private URL getWsdlURL(String wsdlLocation, URI classLoaderId) {
        if (wsdlLocation == null) {
            return null;
        }
        try {
            return new URL(wsdlLocation);
        }
        catch (MalformedURLException e) {
            return this.getClass().getClassLoader().getResource(wsdlLocation);
        }
    }

    private AxisService createAxisClientService(Axis2WireTargetDefinition target) throws WiringException {
        URL wsdlURL = this.getWsdlURL(target.getWsdlLocation(), target.getClassloaderURI());
        if (wsdlURL != null) {
            try {
                return AxisService.createClientSideAxisService((URL)wsdlURL, (QName)target.getWsdlElement().getServiceName(), (String)target.getWsdlElement().getPortName().getLocalPart(), (Options)new Options());
            }
            catch (AxisFault e) {
                throw new WiringException((Throwable)e);
            }
        }
        return null;
    }
}

