/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.binding.ws.axis2.runtime.jaxb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebParam;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.sca4j.binding.ws.axis2.runtime.jaxb.Jaxb2OMElement;
import org.sca4j.binding.ws.axis2.runtime.jaxb.MessageData;

public class JaxbMessageContentBuilder {
    private final Method interceptedMethod;
    private final Object[] payload;
    private final Jaxb2OMElement outTransformer;

    public JaxbMessageContentBuilder(Method interceptedMethod, JAXBContext jaxbContext, Object[] payload) {
        this.interceptedMethod = interceptedMethod;
        this.payload = payload;
        this.outTransformer = new Jaxb2OMElement(jaxbContext);
    }

    public List<MessageData> build() {
        int index = 0;
        Annotation[][] parameterAnnotations = this.interceptedMethod.getParameterAnnotations();
        Class<?>[] parameterTypes = this.interceptedMethod.getParameterTypes();
        ArrayList<MessageData> messageContent = new ArrayList<MessageData>();
        for (Object jaxbObject : this.payload) {
            Annotation[] annotations;
            boolean header = false;
            Class<?> payloadItemClass = jaxbObject.getClass();
            Class<?> parameterType = parameterTypes[index];
            for (Annotation annotation : annotations = parameterAnnotations[index]) {
                if (!annotation.annotationType().equals(WebParam.class)) continue;
                WebParam webParam = (WebParam)annotation;
                header = webParam.header();
                if (payloadItemClass.equals(parameterType)) continue;
                String name = webParam.name();
                String targetNamespace = webParam.targetNamespace();
                QName qname = new QName(targetNamespace, name);
                JAXBElement element = new JAXBElement(qname, parameterType, null, jaxbObject);
                jaxbObject = element;
            }
            OMElement omElement = this.outTransformer.transform(jaxbObject, null);
            messageContent.add(new MessageData(omElement, header));
            ++index;
        }
        return messageContent;
    }
}

