/*
 * Decompiled with CFR 0.152.
 */
package org.sca4.runtime.generic.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.sca4.runtime.generic.impl.policy.PolicyDecorator;
import org.sca4j.fabric.runtime.AbstractRuntime;
import org.sca4j.fabric.runtime.ComponentNames;
import org.sca4j.host.runtime.BootConfiguration;
import org.sca4j.host.runtime.HostInfo;
import org.sca4j.host.runtime.SCA4JRuntime;
import org.sca4j.introspection.impl.contract.JavaServiceContract;
import org.sca4j.java.runtime.JavaComponent;
import org.sca4j.monitor.MonitorFactory;
import org.sca4j.pojo.PojoWorkContextTunnel;
import org.sca4j.runtime.generic.GenericHostInfo;
import org.sca4j.runtime.generic.GenericRuntime;
import org.sca4j.scdl.ServiceContract;
import org.sca4j.services.xmlfactory.XMLFactory;
import org.sca4j.services.xmlfactory.XMLFactoryInstantiationException;
import org.sca4j.spi.binding.BindingProxyProviderRegistry;
import org.sca4j.spi.component.AtomicComponent;
import org.sca4j.spi.component.InstanceLifecycleException;
import org.sca4j.spi.component.InstanceWrapper;
import org.sca4j.spi.domain.Domain;
import org.sca4j.spi.invocation.CallFrame;
import org.sca4j.spi.invocation.WorkContext;
import org.sca4j.spi.model.instance.LogicalComponent;
import org.sca4j.spi.model.instance.LogicalCompositeComponent;
import org.sca4j.spi.model.instance.LogicalService;
import org.sca4j.spi.services.lcm.LogicalComponentManager;

public class GenericRuntimeImpl
extends AbstractRuntime<GenericHostInfo>
implements GenericRuntime {
    public GenericRuntimeImpl(URI domain, Properties hostProperties, MonitorFactory monitorFactory, MBeanServer mBeanServer) {
        super(GenericHostInfo.class);
        this.setHostInfo((HostInfo)new GenericHostInfo(domain, hostProperties));
        this.setMBeanServer(mBeanServer);
        this.setMonitorFactory(monitorFactory);
    }

    public void contriute(String scdlPath) {
        try {
            URL applicationScdlUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(scdlPath);
            applicationScdlUrl = applicationScdlUrl.toURI().toURL();
            QName compositeQName = this.parseCompositeQName(applicationScdlUrl);
            Domain domain = (Domain)this.getSystemComponent(Domain.class, ComponentNames.APPLICATION_DOMAIN_URI);
            domain.include(compositeQName);
            WorkContext workContext = new WorkContext();
            CallFrame frame = new CallFrame((Object)URI.create("test"));
            workContext.addCallFrame(frame);
            this.getScopeContainer().startContext(workContext);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public void boot() {
        try {
            BootConfiguration bootConfiguration = this.getBootConfiguration();
            this.bootPrimordial(bootConfiguration);
            this.bootSystem();
            this.joinDomain(-1L);
            this.start();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public <T> T getBinding(Class<T> endpointInterface, QName bindingType, URI endpointUri, QName ... intents) {
        BindingProxyProviderRegistry providerRegistry = (BindingProxyProviderRegistry)this.getSystemComponent(BindingProxyProviderRegistry.class, URI.create("sca4j://runtime/BindingProxyProviderRegistry"));
        return (T)providerRegistry.getBinding(bindingType, endpointInterface, endpointUri, intents);
    }

    public List<String> getServices() {
        LogicalComponentManager logicalComponentManager = (LogicalComponentManager)this.getSystemComponent(LogicalComponentManager.class, URI.create("sca4j://runtime/LogicalComponentManager"));
        LogicalCompositeComponent domainComponent = logicalComponentManager.getRootComponent();
        LinkedList<String> services = new LinkedList<String>();
        for (LogicalService logicalService : domainComponent.getServices()) {
            services.add(logicalService.getUri().toASCIIString().substring(1));
        }
        return services;
    }

    public <T> T getServiceProxy(String serviceName) {
        LogicalComponentManager logicalComponentManager = (LogicalComponentManager)this.getSystemComponent(LogicalComponentManager.class, URI.create("sca4j://runtime/LogicalComponentManager"));
        LogicalCompositeComponent domainComponent = logicalComponentManager.getRootComponent();
        LogicalComponent<?> logicalComponent = this.getUri(domainComponent, serviceName);
        JavaServiceContract serviceContract = (JavaServiceContract)this.getServiceContract(domainComponent, serviceName);
        URI uri = logicalComponent.getUri();
        JavaComponent javaComponent = (JavaComponent)this.getComponentManager().getComponent(uri);
        WorkContext workContext = new WorkContext();
        WorkContext oldContext = PojoWorkContextTunnel.setThreadWorkContext((WorkContext)workContext);
        try {
            InstanceWrapper wrapper = javaComponent.getScopeContainer().getWrapper((AtomicComponent)javaComponent, workContext);
            Object instance = wrapper.getInstance();
            List intents = logicalComponent.getIntents();
            if (intents == null) {
                Object object = instance;
                return (T)object;
            }
            PolicyDecorator policyDecorator = (PolicyDecorator)this.getSystemComponent(PolicyDecorator.class, URI.create("sca4j://runtime/PolicyDecorator"));
            Object object = policyDecorator.getDecoratedService(instance, serviceContract.getQualifiedInterfaceName(), intents);
            return (T)object;
        }
        catch (InstanceLifecycleException e) {
            throw new AssertionError();
        }
        finally {
            PojoWorkContextTunnel.setThreadWorkContext((WorkContext)oldContext);
        }
    }

    private LogicalComponent<?> getUri(LogicalCompositeComponent parent, String serviceName) {
        LogicalService logicalService = parent.getService(serviceName);
        URI promotedUri = logicalService.getPromotedUri();
        String fragment = promotedUri.getFragment();
        URI componentUri = URI.create(promotedUri.toString().substring(0, promotedUri.toString().indexOf(35)));
        LogicalComponent logicalComponent = parent.getComponent(componentUri);
        if (logicalComponent instanceof LogicalCompositeComponent) {
            LogicalCompositeComponent logicalCompositeComponent = (LogicalCompositeComponent)logicalComponent;
            return this.getUri(logicalCompositeComponent, fragment);
        }
        return logicalComponent;
    }

    private ServiceContract getServiceContract(LogicalCompositeComponent parent, String serviceName) {
        LogicalService logicalService = parent.getService(serviceName);
        URI promotedUri = logicalService.getPromotedUri();
        String fragment = promotedUri.getFragment();
        URI componentUri = URI.create(promotedUri.toString().substring(0, promotedUri.toString().indexOf(35)));
        LogicalComponent logicalComponent = parent.getComponent(componentUri);
        if (logicalComponent instanceof LogicalCompositeComponent) {
            LogicalCompositeComponent logicalCompositeComponent = (LogicalCompositeComponent)logicalComponent;
            return this.getServiceContract(logicalCompositeComponent, fragment);
        }
        return logicalComponent.getService(fragment).getDefinition().getServiceContract();
    }

    private BootConfiguration getBootConfiguration() throws IOException, XMLFactoryInstantiationException, XMLStreamException, URISyntaxException {
        BootConfiguration bootConfiguration = new BootConfiguration();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        bootConfiguration.setAppClassLoader(classLoader);
        bootConfiguration.setBootClassLoader(classLoader);
        bootConfiguration.setHostClassLoader(classLoader);
        bootConfiguration.setRuntime((SCA4JRuntime)this);
        bootConfiguration.setSystemConfig(classLoader.getResourceAsStream("META-INF/systemConfig.xml"));
        bootConfiguration.setSystemScdl(classLoader.getResource("META-INF/system.composite"));
        return bootConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QName parseCompositeQName(URL url) throws IOException, XMLStreamException {
        XMLStreamReader reader = null;
        InputStream stream = null;
        try {
            stream = url.openStream();
            XMLFactory xmlFactory = (XMLFactory)this.getSystemComponent(XMLFactory.class, ComponentNames.XML_FACTORY_URI);
            reader = xmlFactory.newInputFactoryInstance().createXMLStreamReader(stream);
            reader.nextTag();
            String name = reader.getAttributeValue(null, "name");
            String targetNamespace = reader.getAttributeValue(null, "targetNamespace");
            QName qName = new QName(targetNamespace, name);
            return qName;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }
}

