/*
 * Decompiled with CFR 0.152.
 */
package org.sca4.runtime.generic.impl.contribution;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;
import org.sca4j.fabric.services.contribution.processor.AbstractContributionProcessor;
import org.sca4j.fabric.util.FileHelper;
import org.sca4j.host.contribution.ContributionException;
import org.sca4j.spi.services.contenttype.ContentTypeResolutionException;
import org.sca4j.spi.services.contenttype.ContentTypeResolver;
import org.sca4j.spi.services.contribution.Action;
import org.sca4j.spi.services.contribution.Contribution;

@EagerInit
public class ClasspathContributionProcessor
extends AbstractContributionProcessor {
    @Reference
    protected ContentTypeResolver contentTypeResolver;

    protected URL getManifestUrl(Contribution contribution) throws MalformedURLException {
        return new URL(contribution.getLocation().toExternalForm() + "/META-INF/sca-contribution.xml");
    }

    protected void iterateArtifacts(Contribution contribution, Action action) throws ContributionException {
        File root = FileHelper.toFile((URL)contribution.getLocation());
        assert (root.isDirectory());
        this.iterateArtifactsResursive(contribution, action, root);
    }

    private void iterateArtifactsResursive(Contribution contribution, Action action, File dir) throws ContributionException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.iterateArtifactsResursive(contribution, action, file);
                continue;
            }
            try {
                URL entryUrl = file.toURI().toURL();
                String contentType = this.contentTypeResolver.getContentType(entryUrl);
                action.process(contribution, contentType, entryUrl);
            }
            catch (MalformedURLException e) {
                throw new ContributionException((Throwable)e);
            }
            catch (ContentTypeResolutionException e) {
                throw new ContributionException((Throwable)e);
            }
        }
    }
}

