/*
 * Decompiled with CFR 0.152.
 */
package org.sca4.runtime.generic.impl.policy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.oasisopen.sca.ServiceUnavailableException;
import org.oasisopen.sca.annotation.Reference;
import org.sca4.runtime.generic.impl.policy.PolicyDecorator;
import org.sca4j.fabric.wire.InvocationChainImpl;
import org.sca4j.scdl.definitions.PolicyPhase;
import org.sca4j.scdl.definitions.PolicySet;
import org.sca4j.spi.builder.BuilderException;
import org.sca4j.spi.builder.interceptor.InterceptorBuilder;
import org.sca4j.spi.generator.GenerationException;
import org.sca4j.spi.generator.GeneratorNotFoundException;
import org.sca4j.spi.generator.GeneratorRegistry;
import org.sca4j.spi.generator.InterceptorDefinitionGenerator;
import org.sca4j.spi.invocation.Message;
import org.sca4j.spi.invocation.MessageImpl;
import org.sca4j.spi.model.physical.PhysicalInterceptorDefinition;
import org.sca4j.spi.services.definitions.DefinitionsRegistry;
import org.sca4j.spi.wire.Interceptor;
import org.w3c.dom.Element;

public class DefaultPolicyDecorator
implements PolicyDecorator {
    @Reference
    protected DefinitionsRegistry definitionsRegistry;
    @Reference
    protected GeneratorRegistry generatorRegistry;
    @Reference
    protected Map<Class<? extends PhysicalInterceptorDefinition>, InterceptorBuilder<?, ?>> interceptorBuilders;

    @Override
    public <T> T getDecoratedService(T instance, String serviceClassName, List<QName> intents) {
        try {
            Class<?> serviceClass = Class.forName(serviceClassName);
            HashMap<Method, Interceptor> interceptors = new HashMap<Method, Interceptor>();
            for (Method method : serviceClass.getDeclaredMethods()) {
                InvocationChainImpl invocationChain = new InvocationChainImpl(null);
                for (QName intent : intents) {
                    for (PolicySet policySet : this.definitionsRegistry.getAllDefinitions(PolicySet.class)) {
                        if (!policySet.doesProvide(intent) || policySet.getPhase() != PolicyPhase.INTERCEPTION) continue;
                        Element policy = policySet.getExtension();
                        InterceptorDefinitionGenerator generator = this.generatorRegistry.getInterceptorDefinitionGenerator(policySet.getExtensionName());
                        PhysicalInterceptorDefinition pid = generator.generate(policy, null, null);
                        Interceptor interceptor = this.getBuilder(pid).build(pid);
                        invocationChain.addInterceptor(interceptor);
                    }
                }
                InvokerIterceptor invokerIterceptor = new InvokerIterceptor();
                invokerIterceptor.method = method;
                invokerIterceptor.instance = instance;
                invocationChain.addInterceptor((Interceptor)invokerIterceptor);
                interceptors.put(method, invocationChain.getHeadInterceptor());
            }
            PolicyHandler handler = new PolicyHandler();
            handler.interceptors = interceptors;
            return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceClass}, (InvocationHandler)handler);
        }
        catch (GeneratorNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (GenerationException e) {
            throw new AssertionError((Object)e);
        }
        catch (BuilderException e) {
            throw new AssertionError((Object)e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <PID extends PhysicalInterceptorDefinition> InterceptorBuilder<PID, ?> getBuilder(PID definition) {
        return this.interceptorBuilders.get(definition.getClass());
    }

    private class InvokerIterceptor
    implements Interceptor {
        private Object instance;
        private Method method;

        private InvokerIterceptor() {
        }

        public Interceptor getNext() {
            return null;
        }

        public Message invoke(Message msg) {
            try {
                Object ret = this.method.invoke(this.instance, (Object[])msg.getBody());
                msg.setBody(ret);
                return msg;
            }
            catch (Throwable th) {
                throw new ServiceUnavailableException(th);
            }
        }

        public void setNext(Interceptor next) {
        }
    }

    private class PolicyHandler
    implements InvocationHandler {
        private Map<Method, Interceptor> interceptors;

        private PolicyHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            MessageImpl messageImpl = new MessageImpl();
            messageImpl.setBody((Object)args);
            return this.interceptors.get(method).invoke((Message)messageImpl).getBody();
        }
    }
}

