/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.introspection;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.sca4j.host.contribution.ValidationFailure;
import org.sca4j.introspection.IntrospectionContext;
import org.sca4j.introspection.TypeMapping;

public class DefaultIntrospectionContext
implements IntrospectionContext {
    private final List<ValidationFailure<?>> errors = new ArrayList();
    private final List<ValidationFailure<?>> warnings = new ArrayList();
    private final ClassLoader targetClassLoader;
    private final URL sourceBase;
    private final String targetNamespace;
    private final URI contributionUri;
    private final TypeMapping typeMapping;

    public DefaultIntrospectionContext(ClassLoader targetClassLoader, URL sourceBase, String targetNamespace, URI contributionUri, TypeMapping typeMapping) {
        this.targetClassLoader = targetClassLoader;
        this.sourceBase = sourceBase;
        this.targetNamespace = targetNamespace;
        this.contributionUri = contributionUri;
        this.typeMapping = typeMapping;
    }

    public DefaultIntrospectionContext(URI contributionUri, ClassLoader classLoader, String targetNamespace) {
        this(classLoader, null, targetNamespace, contributionUri, null);
    }

    public DefaultIntrospectionContext(ClassLoader classLoader, URI contributionUri, URL scdlLocation) {
        this(classLoader, scdlLocation, null, contributionUri, null);
    }

    public DefaultIntrospectionContext(IntrospectionContext parentContext, String targetNamespace) {
        this(parentContext.getTargetClassLoader(), parentContext.getSourceBase(), targetNamespace, parentContext.getContributionUri(), parentContext.getTypeMapping());
    }

    public DefaultIntrospectionContext(IntrospectionContext parentContext, TypeMapping typeMapping) {
        this(parentContext.getTargetClassLoader(), parentContext.getSourceBase(), parentContext.getTargetNamespace(), parentContext.getContributionUri(), typeMapping);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<ValidationFailure<?>> getErrors() {
        return this.errors;
    }

    public void addError(ValidationFailure<?> e) {
        this.errors.add(e);
    }

    public void addErrors(List<ValidationFailure<?>> errors) {
        this.errors.addAll(errors);
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<ValidationFailure<?>> getWarnings() {
        return this.warnings;
    }

    public void addWarning(ValidationFailure<?> e) {
        this.warnings.add(e);
    }

    public void addWarnings(List<ValidationFailure<?>> warnings) {
        this.warnings.addAll(warnings);
    }

    @Override
    public ClassLoader getTargetClassLoader() {
        return this.targetClassLoader;
    }

    @Override
    public URL getSourceBase() {
        return this.sourceBase;
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    @Override
    public URI getContributionUri() {
        return this.contributionUri;
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }
}

