/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.introspection;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;

public class TypeMapping {
    private final Map<? super Type, Type> mappings = new HashMap<Type, Type>();

    public void addMapping(TypeVariable<?> typeVariable, Type type) {
        this.mappings.put(typeVariable, type);
    }

    public Type getActualType(Type type) {
        Type actual;
        while ((actual = this.mappings.get(type)) != null) {
            type = actual;
        }
        return type;
    }

    public Class<?> getRawType(Type type) {
        Type actualType = this.getActualType(type);
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        if (actualType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualType;
            return this.getRawType(typeVariable.getBounds()[0]);
        }
        if (actualType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actualType;
            return (Class)parameterizedType.getRawType();
        }
        if (actualType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)actualType;
            Class<?> componentType = this.getRawType(arrayType.getGenericComponentType());
            return Array.newInstance(componentType, 0).getClass();
        }
        if (actualType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)actualType;
            Type[] bounds = wildcardType.getUpperBounds();
            return this.getRawType(bounds[0]);
        }
        throw new AssertionError();
    }
}

