/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.introspection.java;

import org.sca4j.host.contribution.ValidationFailure;
import org.sca4j.scdl.ConstructorInjectionSite;
import org.sca4j.scdl.FieldInjectionSite;
import org.sca4j.scdl.InjectableAttributeType;
import org.sca4j.scdl.InjectionSite;
import org.sca4j.scdl.MethodInjectionSite;

public class UnknownInjectionType
extends ValidationFailure<InjectionSite> {
    private InjectableAttributeType type;
    private String clazz;

    public UnknownInjectionType(InjectionSite site, InjectableAttributeType type, String clazz) {
        super((Object)site);
        this.type = type;
        this.clazz = clazz;
    }

    public String getImplementationClass() {
        return this.clazz;
    }

    public String getMessage() {
        InjectionSite site = (InjectionSite)this.getValidatable();
        if (site instanceof FieldInjectionSite) {
            FieldInjectionSite field = (FieldInjectionSite)site;
            return "Unknow injection type " + this.type + " on field " + field.getName() + " in class " + this.clazz;
        }
        if (site instanceof MethodInjectionSite) {
            MethodInjectionSite method = (MethodInjectionSite)site;
            return "Unknow injection type " + this.type + " on method " + method.getSignature() + " in class " + this.clazz;
        }
        if (site instanceof ConstructorInjectionSite) {
            ConstructorInjectionSite ctor = (ConstructorInjectionSite)site;
            return "Unknow injection type " + this.type + " on constructor " + ctor.getSignature() + " in class " + this.clazz;
        }
        return "Unknow injection type " + this.type + " found in class " + this.clazz;
    }
}

