/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.introspection.validation;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sca4j.host.contribution.ValidationFailure;
import org.sca4j.introspection.validation.ValidationExceptionComparator;
import org.sca4j.scdl.ArtifactValidationFailure;

public final class ValidationUtils {
    private static ValidationExceptionComparator COMPARATOR = new ValidationExceptionComparator();

    private ValidationUtils() {
    }

    public static String outputErrors(List<ValidationFailure<?>> failures) {
        return ValidationUtils.output(failures, TYPE.ERROR);
    }

    public static String outputWarnings(List<ValidationFailure<?>> failures) {
        return ValidationUtils.output(failures, TYPE.WARNING);
    }

    public static void writeErrors(PrintWriter writer, List<ValidationFailure<?>> failures) {
        ValidationUtils.write(writer, failures, TYPE.ERROR);
    }

    public static void writeWarnings(PrintWriter writer, List<ValidationFailure<?>> failures) {
        ValidationUtils.write(writer, failures, TYPE.WARNING);
    }

    private static String output(List<ValidationFailure<?>> failures, TYPE type) {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bas);
        ValidationUtils.write(writer, failures, type);
        return bas.toString();
    }

    private static void write(PrintWriter writer, List<ValidationFailure<?>> failures, TYPE type) {
        int count = 0;
        ArrayList sorted = new ArrayList(failures);
        Collections.sort(sorted, COMPARATOR);
        for (ValidationFailure validationFailure : sorted) {
            count = ValidationUtils.writerError(validationFailure, writer, count, type);
        }
        if (count == 1) {
            if (type == TYPE.ERROR) {
                writer.write("1 error was found \n\n");
            } else {
                writer.write("1 warning was found \n\n");
            }
        } else if (type == TYPE.ERROR) {
            writer.write(count + " errors were found \n\n");
        } else if (count != 0) {
            writer.write(count + " warnings were found \n\n");
        }
        writer.flush();
    }

    private static int writerError(ValidationFailure<?> failure, PrintWriter writer, int count, TYPE type) {
        if (failure instanceof ArtifactValidationFailure) {
            ArtifactValidationFailure artifactFailure = (ArtifactValidationFailure)failure;
            if (!ValidationUtils.errorsOnlyInContainedArtifacts(artifactFailure)) {
                if (type == TYPE.ERROR) {
                    writer.write("Errors in " + artifactFailure.getArtifactName() + "\n\n");
                } else {
                    writer.write("Warnings in " + artifactFailure.getArtifactName() + "\n\n");
                }
            }
            for (ValidationFailure childFailure : artifactFailure.getFailures()) {
                count = ValidationUtils.writerError(childFailure, writer, count, type);
            }
        } else {
            if (type == TYPE.ERROR) {
                writer.write("  ERROR: " + failure.getMessage() + "\n\n");
            } else {
                writer.write("  WARNING: " + failure.getMessage() + "\n\n");
            }
            ++count;
        }
        return count;
    }

    private static boolean errorsOnlyInContainedArtifacts(ArtifactValidationFailure artifactFailure) {
        for (ValidationFailure failure : artifactFailure.getFailures()) {
            if (failure instanceof ArtifactValidationFailure) continue;
            return false;
        }
        return true;
    }

    private static enum TYPE {
        WARNING,
        ERROR;

    }
}

