/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.introspection.xml;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.sca4j.host.contribution.ValidationFailure;

public abstract class XmlValidationFailure<T>
extends ValidationFailure<T> {
    private final int line;
    private final int column;
    private final String message;
    private String resourceURI;

    protected XmlValidationFailure(String message, T modelObject, XMLStreamReader reader) {
        super(modelObject);
        this.message = message;
        Location location = reader.getLocation();
        this.line = location.getLineNumber();
        this.column = location.getColumnNumber();
        this.resourceURI = location.getSystemId();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.message);
        if (this.line != -1) {
            builder.append(" [").append(this.line).append(',').append(this.column).append("]");
        }
        return builder.toString();
    }
}

