/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.erlang;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.nio.charset.Charset;
import org.sonar.erlang.ErlangCommentAnalyser;
import org.sonar.erlang.api.ErlangMetric;
import org.sonar.erlang.metrics.BranchesOfRecursion;
import org.sonar.erlang.metrics.ErlangComplexityVisitor;
import org.sonar.erlang.metrics.ErlangStatementVisitor;
import org.sonar.erlang.metrics.NumberOfFunctionArgument;
import org.sonar.erlang.metrics.PublicDocumentedApiCounter;
import org.sonar.erlang.parser.ErlangGrammarImpl;
import org.sonar.squidbridge.AstScanner;
import org.sonar.squidbridge.CommentAnalyser;
import org.sonar.squidbridge.SourceCodeBuilderCallback;
import org.sonar.squidbridge.SourceCodeBuilderVisitor;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.SquidAstVisitorContextImpl;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.squidbridge.metrics.CommentsVisitor;
import org.sonar.squidbridge.metrics.ComplexityVisitor;
import org.sonar.squidbridge.metrics.CounterVisitor;
import org.sonar.squidbridge.metrics.LinesOfCodeVisitor;
import org.sonar.squidbridge.metrics.LinesVisitor;
import org.sonar.sslr.parser.LexerlessGrammar;
import org.sonar.sslr.parser.ParserAdapter;

public final class ErlangAstScanner {
    private ErlangAstScanner() {
    }

    public static AstScanner<LexerlessGrammar> create(Charset charset, SquidAstVisitor<LexerlessGrammar> ... visitors) {
        SquidAstVisitorContextImpl context = new SquidAstVisitorContextImpl(new SourceProject("Erlang Project"));
        ParserAdapter<LexerlessGrammar> parser = new ParserAdapter<LexerlessGrammar>(charset, ErlangGrammarImpl.createGrammar());
        AstScanner.Builder builder = AstScanner.builder((SquidAstVisitorContextImpl)context).setBaseParser(parser);
        builder.withMetrics((MetricDef[])ErlangMetric.values());
        builder.setCommentAnalyser((CommentAnalyser)new ErlangCommentAnalyser());
        builder.setFilesMetric((MetricDef)ErlangMetric.FILES);
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                String className = astNode.getFirstDescendant(ErlangGrammarImpl.moduleAttr).getFirstChild(ErlangGrammarImpl.atom).getTokenValue();
                SourceClass cls = new SourceClass(className + ":" + astNode.getToken().getLine());
                cls.setStartAtLine(astNode.getTokenLine());
                return cls;
            }
        }, new AstNodeType[]{ErlangGrammarImpl.module}));
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)ErlangMetric.MODULES).subscribeTo(new AstNodeType[]{ErlangGrammarImpl.module}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                String functionKey = this.getFunctionKey(astNode);
                SourceFunction function = new SourceFunction(functionKey);
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }

            private String getFunctionKey(AstNode ast) {
                if (ast.getType().equals(ErlangGrammarImpl.funExpression)) {
                    AstNode funcArity = ast.getFirstChild(ErlangGrammarImpl.funcArity);
                    if (funcArity == null) {
                        AstNode args = ast.getFirstDescendant(ErlangGrammarImpl.functionDeclarationNoName).getFirstChild(ErlangGrammarImpl.arguments);
                        return "FUN/" + this.countArgs(args) + ":" + ast.getTokenLine() + "," + ast.getToken().getColumn();
                    }
                    return "FUN/" + funcArity.getTokenOriginalValue() + "/" + funcArity.getChildren(ErlangGrammarImpl.literal).get(1).getTokenOriginalValue();
                }
                AstNode clause = null;
                boolean isDec = false;
                if (ast.getType().equals(ErlangGrammarImpl.functionDeclaration)) {
                    clause = ast.getFirstDescendant(ErlangGrammarImpl.functionClause);
                    isDec = true;
                } else {
                    clause = ast;
                }
                String functionName = clause.getFirstChild(ErlangGrammarImpl.clauseHead).getTokenValue();
                return functionName + "/" + this.getArity(clause) + (!isDec ? "c" : "") + ":" + clause.getTokenLine();
            }

            private String getArity(AstNode ast) {
                AstNode args = ast.getFirstChild(ErlangGrammarImpl.clauseHead).getFirstChild(ErlangGrammarImpl.funcDecl).getFirstChild(ErlangGrammarImpl.arguments);
                return this.countArgs(args);
            }

            private String countArgs(AstNode args) {
                int num = args.getNumberOfChildren() > 3 ? args.getChildren(ErlangGrammarImpl.comma).size() + 1 : args.getNumberOfChildren() - 2;
                return String.valueOf(num);
            }
        }, new AstNodeType[]{ErlangGrammarImpl.functionDeclaration, ErlangGrammarImpl.functionClause, ErlangGrammarImpl.funExpression}));
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)ErlangMetric.FUNCTIONS).subscribeTo(new AstNodeType[]{ErlangGrammarImpl.functionDeclaration}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesVisitor((MetricDef)ErlangMetric.LINES));
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesOfCodeVisitor((MetricDef)ErlangMetric.LINES_OF_CODE));
        builder.withSquidAstVisitor((SquidAstVisitor)CommentsVisitor.builder().withCommentMetric((MetricDef)ErlangMetric.COMMENT_LINES).withNoSonar(true).withIgnoreHeaderComment(false).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new ErlangStatementVisitor());
        builder.withSquidAstVisitor((SquidAstVisitor)new ErlangComplexityVisitor());
        builder.withSquidAstVisitor((SquidAstVisitor)new PublicDocumentedApiCounter());
        builder.withSquidAstVisitor((SquidAstVisitor)new NumberOfFunctionArgument());
        builder.withSquidAstVisitor((SquidAstVisitor)new BranchesOfRecursion());
        builder.withSquidAstVisitor((SquidAstVisitor)ComplexityVisitor.builder().setMetricDef((MetricDef)ErlangMetric.NUM_OF_FUN_EXRP).subscribeTo(new AstNodeType[]{ErlangGrammarImpl.funExpression}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)ComplexityVisitor.builder().setMetricDef((MetricDef)ErlangMetric.NUM_OF_FUN_CLAUSES).subscribeTo(new AstNodeType[]{ErlangGrammarImpl.functionClause}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)ComplexityVisitor.builder().setMetricDef((MetricDef)ErlangMetric.NUM_OF_MACROS).subscribeTo(new AstNodeType[]{ErlangGrammarImpl.defineAttr}).build());
        for (SquidAstVisitor<LexerlessGrammar> visitor : visitors) {
            builder.withSquidAstVisitor(visitor);
        }
        return builder.build();
    }
}

