/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.erlang.metrics;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.erlang.api.ErlangMetric;
import org.sonar.erlang.parser.ErlangGrammarImpl;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

public class BranchesOfRecursion
extends SquidCheck<LexerlessGrammar> {
    private String actualArity;
    private String actualModule;

    public void init() {
        this.subscribeTo(new AstNodeType[]{ErlangGrammarImpl.functionDeclaration, ErlangGrammarImpl.callExpression});
    }

    public void visitFile(AstNode astNode) {
        if (astNode == null) {
            return;
        }
        this.actualArity = "";
        this.actualModule = astNode.getFirstDescendant(ErlangGrammarImpl.moduleAttr).getFirstChild(ErlangGrammarImpl.atom).getTokenOriginalValue();
    }

    public void visitNode(AstNode ast) {
        if (ast.getType().equals(ErlangGrammarImpl.functionDeclaration)) {
            this.actualArity = this.getArity(ast.getFirstChild(ErlangGrammarImpl.functionClause));
        }
        if (ast.getType().equals(ErlangGrammarImpl.callExpression) && this.getArityFromCall(ast).equals(this.actualArity)) {
            this.getContext().peekSourceCode().add((MetricDef)ErlangMetric.BRANCHES_OF_RECURSION, 1.0);
        }
    }

    private String getArityFromCall(AstNode ast) {
        if (ast.hasDirectChildren(ErlangGrammarImpl.colon)) {
            AstNode firstCallMemberAstNode = ast.getFirstChild(ErlangGrammarImpl.callExpressionFirstMember);
            AstNode secondCallMemberAstNode = ast.getLastChild(ErlangGrammarImpl.callExpressionSecondMember);
            if (this.actualModule.equals(firstCallMemberAstNode.getTokenOriginalValue())) {
                return secondCallMemberAstNode.getTokenOriginalValue() + "/" + this.getNumOfArgs(ast.getFirstChild(ErlangGrammarImpl.arguments));
            }
            return firstCallMemberAstNode.getFirstChild() + ":" + secondCallMemberAstNode.getTokenOriginalValue() + "/" + this.getNumOfArgs(ast.getFirstChild(ErlangGrammarImpl.arguments));
        }
        try {
            AstNode secondCallMemberAstNode = ast.getLastChild(ErlangGrammarImpl.callExpressionSecondMember);
            return secondCallMemberAstNode.getFirstChild(ErlangGrammarImpl.primaryExpression).getFirstChild(ErlangGrammarImpl.literal).getTokenOriginalValue() + "/" + this.getNumOfArgs(ast.getFirstChild(ErlangGrammarImpl.arguments));
        }
        catch (Exception e) {
            return "*" + this.getNumOfArgs(ast.getFirstChild(ErlangGrammarImpl.arguments));
        }
    }

    private String getArity(AstNode ast) {
        AstNode args = ast.getFirstChild(ErlangGrammarImpl.clauseHead).getFirstChild(ErlangGrammarImpl.funcDecl).getFirstChild(ErlangGrammarImpl.arguments);
        return ast.getTokenOriginalValue() + "/" + this.getNumOfArgs(args);
    }

    private String getNumOfArgs(AstNode args) {
        int num = args.getNumberOfChildren() > 3 ? args.getChildren(ErlangGrammarImpl.comma).size() + 1 : args.getNumberOfChildren() - 2;
        return String.valueOf(num);
    }
}

