/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.erlang.metrics;

import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.erlang.api.ErlangMetric;
import org.sonar.erlang.parser.ErlangGrammarImpl;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

public class NumberOfFunctionArgument
extends SquidCheck<LexerlessGrammar> {
    List<ErlangGrammarImpl> nonArg = ImmutableList.of(ErlangGrammarImpl.lparenthesis, ErlangGrammarImpl.rparenthesis, ErlangGrammarImpl.comma);

    public void init() {
        this.subscribeTo(new AstNodeType[]{ErlangGrammarImpl.clauseHead});
    }

    public void visitNode(AstNode ast) {
        AstNode args = ast.getFirstChild(ErlangGrammarImpl.funcDecl).getFirstChild(ErlangGrammarImpl.arguments);
        int numOfArgs = 0;
        for (AstNode arg : args.getChildren()) {
            if (this.nonArg.contains(arg.getType())) continue;
            ++numOfArgs;
        }
        this.getContext().peekSourceCode().add((MetricDef)ErlangMetric.NUM_OF_FUNC_ARGS, (double)numOfArgs);
    }
}

