/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.erlang.metrics;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Trivia;
import java.util.List;
import org.sonar.erlang.api.ErlangMetric;
import org.sonar.erlang.parser.ErlangGrammarImpl;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

public class PublicDocumentedApiCounter
extends SquidAstVisitor<LexerlessGrammar> {
    private double numOfPublicAPIs = 0.0;
    private double numOfPublicDocAPIs = 0.0;
    private List<AstNode> functions;

    public void init() {
        this.subscribeTo(new AstNodeType[]{ErlangGrammarImpl.exportAttr});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.getFirstAncestor((AstNodeType)ErlangGrammarImpl.flowControlAttr) == null) {
            List<AstNode> exports = astNode.getFirstChild(ErlangGrammarImpl.funcExport).getChildren(ErlangGrammarImpl.funcArity);
            this.numOfPublicAPIs += (double)exports.size();
            block0: for (AstNode export : exports) {
                List<Trivia> comments;
                AstNode func = this.findFunctionByArity(this.getArity(export));
                if (func == null || (comments = func.getFirstDescendant(ErlangGrammarImpl.atom).getToken().getTrivia()).isEmpty()) continue;
                for (Trivia trivia : comments) {
                    if (!trivia.isComment() || trivia.getToken().getOriginalValue().matches("^%%+ *(.)\\1+ *$")) continue;
                    this.numOfPublicDocAPIs += 1.0;
                    continue block0;
                }
            }
        }
    }

    public void visitFile(AstNode astNode) {
        if (astNode == null) {
            return;
        }
        this.functions = astNode.getFirstChild(ErlangGrammarImpl.moduleElements).getChildren(ErlangGrammarImpl.functionDeclaration);
    }

    public void leaveFile(AstNode astNode) {
        if (astNode == null) {
            return;
        }
        this.getContext().peekSourceCode().add((MetricDef)ErlangMetric.PUBLIC_API, this.numOfPublicAPIs);
        this.getContext().peekSourceCode().add((MetricDef)ErlangMetric.PUBLIC_DOC_API, this.numOfPublicDocAPIs);
        double density = this.numOfPublicAPIs > 0.0 ? this.numOfPublicDocAPIs / this.numOfPublicAPIs : 0.0;
        this.getContext().peekSourceCode().add((MetricDef)ErlangMetric.PUBLIC_DOCUMENTED_API_DENSITY, density);
        this.functions = null;
    }

    private AstNode findFunctionByArity(String arity) {
        for (AstNode function : this.functions) {
            if (!this.getArity(function).equals(arity)) continue;
            return function;
        }
        return null;
    }

    private String getArity(AstNode node) {
        StringBuilder ret = new StringBuilder();
        if ("funcArity".equalsIgnoreCase(node.getName())) {
            for (AstNode arity : node.getChildren()) {
                ret.append(arity.getTokenOriginalValue());
            }
        } else if ("functionDeclaration".equalsIgnoreCase(node.getName())) {
            ret.append(node.getFirstDescendant(ErlangGrammarImpl.funcDecl).getTokenOriginalValue());
            ret.append("/");
            ret.append(node.getFirstDescendant(ErlangGrammarImpl.arguments).getChildren(ErlangGrammarImpl.comma).size() + 1);
        }
        return ret.toString();
    }
}

