/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.grammar;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeSkippingPolicy;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.impl.ast.AlwaysSkipFromAst;
import com.sonar.sslr.impl.ast.NeverSkipFromAst;
import com.sonar.sslr.impl.ast.SkipFromAstIfOnlyOneChild;
import org.sonar.sslr.grammar.GrammarException;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.vm.CompilableGrammarRule;
import org.sonar.sslr.internal.vm.CompilationHandler;
import org.sonar.sslr.internal.vm.EndOfInputExpression;
import org.sonar.sslr.internal.vm.FirstOfExpression;
import org.sonar.sslr.internal.vm.Instruction;
import org.sonar.sslr.internal.vm.MemoParsingExpression;
import org.sonar.sslr.internal.vm.ParsingExpression;
import org.sonar.sslr.internal.vm.PatternExpression;
import org.sonar.sslr.internal.vm.RuleRefExpression;
import org.sonar.sslr.internal.vm.SequenceExpression;
import org.sonar.sslr.internal.vm.StringExpression;
import org.sonar.sslr.parser.GrammarOperators;

public class MutableParsingRule
implements CompilableGrammarRule,
Matcher,
Rule,
AstNodeSkippingPolicy,
MemoParsingExpression,
GrammarRuleKey {
    private final GrammarRuleKey ruleKey;
    private final String name;
    private ParsingExpression expression;
    private AstNodeSkippingPolicy astNodeSkippingPolicy = NeverSkipFromAst.INSTANCE;

    public MutableParsingRule(String name) {
        this.ruleKey = this;
        this.name = name;
    }

    public MutableParsingRule(GrammarRuleKey ruleKey) {
        this.ruleKey = ruleKey;
        this.name = ruleKey.toString();
    }

    public String getName() {
        return this.name;
    }

    public AstNodeType getRealAstNodeType() {
        return this.ruleKey;
    }

    @Override
    public GrammarRuleKey getRuleKey() {
        return this.ruleKey;
    }

    @Override
    public ParsingExpression getExpression() {
        return this.expression;
    }

    @Override
    public Rule is(Object ... e) {
        if (this.expression != null) {
            throw new GrammarException("The rule '" + this.ruleKey + "' has already been defined somewhere in the grammar.");
        }
        this.setExpression((ParsingExpression)GrammarOperators.sequence(e));
        return this;
    }

    @Override
    public Rule override(Object ... e) {
        this.setExpression((ParsingExpression)GrammarOperators.sequence(e));
        return this;
    }

    @Override
    public void mock() {
        this.setExpression(new SequenceExpression(new StringExpression(this.getName()), new FirstOfExpression(new PatternExpression("\\s++"), EndOfInputExpression.INSTANCE)));
    }

    @Override
    public void setExpression(ParsingExpression expression) {
        this.expression = expression;
    }

    @Override
    public void skip() {
        this.astNodeSkippingPolicy = AlwaysSkipFromAst.INSTANCE;
    }

    @Override
    public void skipIfOneChild() {
        this.astNodeSkippingPolicy = SkipFromAstIfOnlyOneChild.INSTANCE;
    }

    @Override
    public void skipIf(AstNodeSkippingPolicy policy) {
        this.astNodeSkippingPolicy = policy;
    }

    @Override
    public void recoveryRule() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasToBeSkippedFromAst(AstNode node) {
        return this.astNodeSkippingPolicy.hasToBeSkippedFromAst(node);
    }

    @Override
    public Instruction[] compile(CompilationHandler compiler) {
        return compiler.compile(new RuleRefExpression(this.ruleKey));
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean shouldMemoize() {
        return true;
    }
}

