/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.matchers;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.util.ArrayList;
import java.util.List;
import org.sonar.sslr.internal.matchers.ParseNode;
import org.sonar.sslr.internal.vm.lexerful.TokenTypeExpression;

public class LexerfulAstCreator {
    private final List<Token> tokens;

    public static AstNode create(ParseNode node, List<Token> tokens) {
        AstNode astNode = new LexerfulAstCreator(tokens).visit(node);
        astNode.hasToBeSkippedFromAst();
        return astNode;
    }

    private LexerfulAstCreator(List<Token> tokens) {
        this.tokens = tokens;
    }

    private AstNode visit(ParseNode node) {
        if (node.getMatcher() instanceof RuleDefinition) {
            return this.visitNonTerminal(node);
        }
        return this.visitTerminal(node);
    }

    private AstNode visitNonTerminal(ParseNode node) {
        AstNode astNode;
        ArrayList<AstNode> astNodes = Lists.newArrayList();
        for (ParseNode child : node.getChildren()) {
            astNode = this.visit(child);
            if (astNode == null) continue;
            if (astNode.hasToBeSkippedFromAst()) {
                astNodes.addAll(astNode.getChildren());
                continue;
            }
            astNodes.add(astNode);
        }
        RuleDefinition ruleMatcher = (RuleDefinition)node.getMatcher();
        Token token = node.getStartIndex() < this.tokens.size() ? this.tokens.get(node.getStartIndex()) : null;
        astNode = new AstNode(ruleMatcher, ruleMatcher.getName(), token);
        for (AstNode child : astNodes) {
            astNode.addChild(child);
        }
        astNode.setFromIndex(node.getStartIndex());
        astNode.setToIndex(node.getEndIndex());
        return astNode;
    }

    private AstNode visitTerminal(ParseNode node) {
        Token token = this.tokens.get(node.getStartIndex());
        if (node.getMatcher() instanceof TokenTypeExpression && token.getType().hasToBeSkippedFromAst(null)) {
            return null;
        }
        AstNode astNode = new AstNode(token);
        astNode.setFromIndex(node.getStartIndex());
        astNode.setToIndex(node.getEndIndex());
        return astNode;
    }
}

