/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api.symboltable;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.symboltable.Scope;
import com.sonar.sslr.api.symboltable.Symbol;
import java.util.Collection;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SymbolTableBuilderContext {
    private final IdentityHashMap<AstNode, Scope> astToScope = Maps.newIdentityHashMap();
    private final IdentityHashMap<AstNode, Symbol> astToSymbol = Maps.newIdentityHashMap();
    private final Multimap<Symbol, AstNode> references = HashMultimap.create();

    public void define(Symbol symbol) {
        this.getEnclosingScope(symbol.getAstNode()).define(symbol);
        this.astToSymbol.put(symbol.getAstNode(), symbol);
    }

    public void define(AstNode astNode, Scope scope) {
        Scope enclosingScope = scope.getEnclosingScope();
        if (enclosingScope != null) {
            enclosingScope.addNestedScope(scope);
        }
        this.astToScope.put(astNode, scope);
    }

    public Symbol getEnclosingSymbol(AstNode astNode) {
        Symbol result = null;
        while (result == null && astNode != null) {
            result = this.astToSymbol.get(astNode);
            astNode = astNode.getParent();
        }
        return result;
    }

    public Scope getEnclosingScope(AstNode astNode) {
        Scope result = null;
        while (result == null && astNode != null) {
            result = this.astToScope.get(astNode);
            astNode = astNode.getParent();
        }
        return result;
    }

    public void addReference(AstNode astNode, Symbol symbol) {
        this.references.put(symbol, astNode);
    }

    public Collection<AstNode> getReferences(Symbol symbol) {
        return this.references.get(symbol);
    }
}

