/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.devkit;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.Token;
import java.util.Map;

public final class Offsets {
    private final Map<Integer, Integer> lineOffsets = Maps.newHashMap();
    private int endPositionOffset;

    public void computeLineOffsets(String code, int endPositionOffset) {
        this.endPositionOffset = endPositionOffset;
        this.lineOffsets.clear();
        int currentOffset = 1;
        String[] lines = code.split("(\r)?\n", -1);
        for (int line = 1; line <= lines.length; ++line) {
            this.lineOffsets.put(line, currentOffset);
            currentOffset += lines[line - 1].length() + 1;
        }
    }

    public int getLineFromOffset(int offset) {
        int line = 1;
        while (this.lineOffsets.containsKey(line + 1) && offset >= this.lineOffsets.get(line + 1)) {
            ++line;
        }
        return line;
    }

    public int getColumnFromOffsetAndLine(int offset, int line) {
        return offset - this.lineOffsets.get(line);
    }

    public int getStartOffset(Token token) {
        return this.getOffset(token.getLine(), token.getColumn());
    }

    public int getEndOffset(Token token) {
        String[] tokenLines = token.getOriginalValue().split("(\r)?\n", -1);
        int tokenLastLine = token.getLine() + tokenLines.length - 1;
        int tokenLastLineColumn = (tokenLines.length > 1 ? 0 : token.getColumn()) + tokenLines[tokenLines.length - 1].length();
        return this.getOffset(tokenLastLine, tokenLastLineColumn);
    }

    public int getOffset(int line, int column) {
        return this.lineOffsets.containsKey(line) ? Math.min(this.lineOffsets.get(line) + column, this.endPositionOffset - 1) : this.endPositionOffset - 1;
    }
}

