/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.analysis;

import com.google.common.collect.Sets;
import com.sonar.sslr.impl.analysis.EmptyVisitor;
import com.sonar.sslr.impl.analysis.LeftRecursionException;
import com.sonar.sslr.impl.analysis.MatcherVisitor;
import com.sonar.sslr.impl.matcher.AndMatcher;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.OneToNMatcher;
import com.sonar.sslr.impl.matcher.OptMatcher;
import com.sonar.sslr.impl.matcher.OrMatcher;
import com.sonar.sslr.impl.matcher.RuleMatcher;
import com.sonar.sslr.impl.matcher.TokenMatcher;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FirstVisitor {
    private FirstVisitor() {
    }

    public static Set<Matcher> first(Matcher matcher) {
        MatcherVisitor<Set<Matcher>, Stack<RuleMatcher>> visitor = new MatcherVisitor<Set<Matcher>, Stack<RuleMatcher>>(){

            @Override
            public Set<Matcher> visit(TokenMatcher matcher, Stack<RuleMatcher> stack) {
                return Sets.newHashSet(matcher);
            }

            @Override
            public Set<Matcher> visit(OrMatcher matcher, Stack<RuleMatcher> stack) {
                HashSet<Matcher> set = Sets.newHashSet();
                for (Matcher child : matcher.children) {
                    set.addAll((Collection)this.visit(child, stack));
                }
                return set;
            }

            @Override
            public Set<Matcher> visit(AndMatcher matcher, Stack<RuleMatcher> stack) {
                HashSet<Matcher> set = Sets.newHashSet();
                for (Matcher child : matcher.children) {
                    set.addAll((Collection)this.visit(child, stack));
                    if (!EmptyVisitor.empty(child)) break;
                }
                return set;
            }

            @Override
            public Set<Matcher> visit(OptMatcher matcher, Stack<RuleMatcher> stack) {
                return (Set)this.visit(matcher.children[0], stack);
            }

            @Override
            public Set<Matcher> visit(OneToNMatcher matcher, Stack<RuleMatcher> stack) {
                return (Set)this.visit(matcher.children[0], stack);
            }

            @Override
            public Set<Matcher> visit(RuleMatcher matcher, Stack<RuleMatcher> stack) {
                if (stack.contains(matcher)) {
                    stack.push(matcher);
                    throw new LeftRecursionException(stack);
                }
                stack.push(matcher);
                Set set = (Set)this.visit(matcher.children[0], stack);
                stack.pop();
                return set;
            }
        };
        return (Set)visitor.visit(matcher, new Stack());
    }
}

