/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.impl.analysis.EmptyAlternative;
import com.sonar.sslr.impl.analysis.EmptyAlternativeVisitor;
import com.sonar.sslr.impl.analysis.EmptyRepetitionVisitor;
import com.sonar.sslr.impl.analysis.FirstVisitor;
import com.sonar.sslr.impl.analysis.LeftRecursionException;
import com.sonar.sslr.impl.matcher.OneToNMatcher;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import com.sonar.sslr.impl.matcher.RuleMatcher;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarAnalyser {
    private final Set<RuleMatcher> rules;
    private final Map<RuleMatcher, Exception> skippedRules = Maps.newHashMap();
    private final Map<RuleMatcher, LeftRecursionException> dependOnLeftRecursiveRules = Maps.newHashMap();
    private final Map<RuleMatcher, LeftRecursionException> leftRecursiveRules = Maps.newHashMap();
    private final Map<RuleMatcher, Set<OneToNMatcher>> emptyRepetitions = Maps.newHashMap();
    private final Map<RuleMatcher, Set<EmptyAlternative>> emptyAlternatives = Maps.newHashMap();

    public GrammarAnalyser(Grammar grammar) {
        this.rules = this.getRuleMatchers(grammar);
        for (RuleMatcher rule : this.rules) {
            this.detectIssues(rule);
        }
    }

    public Set<RuleMatcher> getRules() {
        return Collections.unmodifiableSet(this.rules);
    }

    public boolean isLeftRecursive(RuleMatcher rule) {
        return this.leftRecursiveRules.containsKey(rule);
    }

    public boolean isDependingOnLeftRecursiveRule(RuleMatcher rule) {
        return this.dependOnLeftRecursiveRules.containsKey(rule);
    }

    public LeftRecursionException getLeftRecursionException(RuleMatcher rule) {
        LeftRecursionException e = this.dependOnLeftRecursiveRules.get(rule);
        if (e == null) {
            e = this.leftRecursiveRules.get(rule);
        }
        Preconditions.checkArgument(e != null, "The given rule \"" + rule.getName() + "\" has no associated left recursion exception");
        return e;
    }

    public boolean hasEmptyRepetitions(RuleMatcher rule) {
        return this.emptyRepetitions.containsKey(rule);
    }

    public Set<OneToNMatcher> getEmptyRepetitions(RuleMatcher rule) {
        Preconditions.checkArgument(this.hasEmptyRepetitions(rule), "The given rule \"" + rule.getName() + "\" has no empty repetitions");
        return this.emptyRepetitions.get(rule);
    }

    public boolean hasEmptyAlternatives(RuleMatcher rule) {
        return this.emptyAlternatives.containsKey(rule);
    }

    public Set<EmptyAlternative> getEmptyAlternatives(RuleMatcher rule) {
        Preconditions.checkArgument(this.hasEmptyAlternatives(rule), "The given rule \"" + rule.getName() + "\" has no empty alternatives");
        return this.emptyAlternatives.get(rule);
    }

    public boolean isSkipped(RuleMatcher rule) {
        return this.skippedRules.containsKey(rule);
    }

    public Exception getSkippedCause(RuleMatcher rule) {
        Preconditions.checkArgument(this.isSkipped(rule), "The given rule \"" + rule.getName() + "\" has not skipped");
        return this.skippedRules.get(rule);
    }

    public boolean hasIssues() {
        return !this.skippedRules.isEmpty() || !this.dependOnLeftRecursiveRules.isEmpty() || !this.leftRecursiveRules.isEmpty() || !this.emptyRepetitions.isEmpty() || !this.emptyAlternatives.isEmpty();
    }

    public boolean hasIssues(RuleMatcher rule) {
        return this.isSkipped(rule) || this.isLeftRecursive(rule) || this.isDependingOnLeftRecursiveRule(rule) || this.hasEmptyRepetitions(rule) || this.hasEmptyAlternatives(rule);
    }

    private Set<RuleMatcher> getRuleMatchers(Grammar grammar) {
        try {
            HashSet<RuleMatcher> ruleMatchers = Sets.newHashSet();
            for (Field ruleField : Grammar.getAllRuleFields(grammar.getClass())) {
                RuleDefinition rule = (RuleDefinition)ruleField.get(grammar);
                ruleMatchers.add(rule.getRule());
            }
            return ruleMatchers;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void detectIssues(RuleMatcher rule) {
        try {
            FirstVisitor.first(rule);
            EmptyRepetitionVisitor emptyRepetitionVisitor = new EmptyRepetitionVisitor();
            emptyRepetitionVisitor.visit(rule);
            if (!emptyRepetitionVisitor.getEmptyRepetitions().isEmpty()) {
                this.emptyRepetitions.put(rule, emptyRepetitionVisitor.getEmptyRepetitions());
            }
            EmptyAlternativeVisitor emptyAlternativeVisitor = new EmptyAlternativeVisitor();
            emptyAlternativeVisitor.visit(rule);
            if (!emptyAlternativeVisitor.getEmptyAlternatives().isEmpty()) {
                this.emptyAlternatives.put(rule, emptyAlternativeVisitor.getEmptyAlternatives());
            }
        }
        catch (LeftRecursionException e) {
            if (rule.equals(e.getLeftRecursiveRule())) {
                this.leftRecursiveRules.put(rule, e);
            } else {
                this.dependOnLeftRecursiveRules.put(rule, e);
            }
        }
        catch (Exception e) {
            this.skippedRules.put(rule, e);
        }
    }
}

