/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.analysis;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.analysis.Violation;
import com.sonar.sslr.impl.analysis.ViolationConfidence;
import com.sonar.sslr.impl.events.AutoCompleter;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.OrMatcher;
import com.sonar.sslr.impl.matcher.RuleMatcher;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrAnalyser {
    public static final String PREFIX_EXAMPLE = "OrAnalyser.PREFIX_EXAMPLE";
    public static final int DEFAULT_MAX_TOKENS = 5;
    private final int maxTokens;
    private RuleMatcher currentRule;
    private List<Violation> emptyAlternativeViolations;
    private List<Violation> prefixAlternativeViolations;
    private List<Violation> potentialPrefixAlternativeViolations;

    public OrAnalyser() {
        this(5);
    }

    public OrAnalyser(int maxTokens) {
        this.maxTokens = maxTokens;
    }

    private boolean tokenEquals(Token token1, Token token2) {
        if (!token1.getType().equals(token2.getType())) {
            return false;
        }
        return token1.getValue().equals(token2.getValue());
    }

    private boolean isPrefix(List<Token> prefix, List<Token> subject) {
        if (prefix.size() > subject.size()) {
            return false;
        }
        for (int i = 0; i < prefix.size(); ++i) {
            if (this.tokenEquals(prefix.get(i), subject.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean canMatchEmptyString(List<List<Token>> prefixes) {
        for (List<Token> prefix : prefixes) {
            if (!prefix.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private List<Token> getOnePrefix(List<List<Token>> prefixes, List<List<Token>> subjects) {
        for (List<Token> subject : subjects) {
            for (List<Token> prefix : prefixes) {
                if (!this.isPrefix(prefix, subject)) continue;
                return prefix;
            }
        }
        return null;
    }

    private void handleEmptyPrefixes(OrMatcher orMatcher, ListMultimap<Integer, List<Token>> fullMatches, ListMultimap<Integer, List<Token>> partialMatches) {
        for (int alternativeIndex = 0; alternativeIndex < orMatcher.children.length; ++alternativeIndex) {
            List<List<Token>> prefixes = fullMatches.get(alternativeIndex);
            if (prefixes == null || !this.canMatchEmptyString(prefixes)) continue;
            this.emptyAlternativeViolations.add(new Violation(orMatcher.children[alternativeIndex], this.currentRule, ViolationConfidence.SURE, orMatcher));
            fullMatches.removeAll(alternativeIndex);
            partialMatches.removeAll(alternativeIndex);
        }
    }

    private void handlePrefixes(OrMatcher orMatcher, ListMultimap<Integer, List<Token>> prefixesForAllAlternatives, ListMultimap<Integer, List<Token>> subjectsForAllAlternatives, List<Violation> violationsList, ViolationConfidence violationConfidence, ListMultimap<Integer, List<Token>> otherPrefixesToDeleteFrom) {
        block0: for (int alternativeIndex = 0; alternativeIndex < orMatcher.children.length; ++alternativeIndex) {
            List<List<Token>> subjects = subjectsForAllAlternatives.get(alternativeIndex);
            if (subjects == null) continue;
            for (int prefixingAlternativeIndex = 0; prefixingAlternativeIndex < alternativeIndex; ++prefixingAlternativeIndex) {
                List<Token> prefixExample;
                List<List<Token>> prefixes = prefixesForAllAlternatives.get(prefixingAlternativeIndex);
                if (prefixes == null || (prefixExample = this.getOnePrefix(prefixes, subjects)) == null) continue;
                violationsList.add(new Violation(orMatcher.children[alternativeIndex], this.currentRule, violationConfidence, orMatcher, orMatcher.children[prefixingAlternativeIndex]).addOrReplaceProperty(PREFIX_EXAMPLE, prefixExample));
                prefixesForAllAlternatives.removeAll(alternativeIndex);
                if (prefixesForAllAlternatives != subjectsForAllAlternatives) {
                    subjectsForAllAlternatives.removeAll(alternativeIndex);
                }
                if (otherPrefixesToDeleteFrom == null) continue block0;
                otherPrefixesToDeleteFrom.removeAll(alternativeIndex);
                continue block0;
            }
        }
    }

    private void handlePartialPrefixes(OrMatcher orMatcher, ListMultimap<Integer, List<Token>> partialMatches, ListMultimap<Integer, List<Token>> alternativesPrefixes) {
        LinkedListMultimap<Integer, Integer> alreadyAdded = LinkedListMultimap.create();
        for (int prefixingAlternativeIndex = 0; prefixingAlternativeIndex < orMatcher.children.length; ++prefixingAlternativeIndex) {
            List<List<Token>> prefixes = partialMatches.get(prefixingAlternativeIndex);
            if (prefixes == null) continue;
            for (List<Token> prefix : prefixes) {
                boolean found = false;
                block2: for (int subjectAlternativeIndex = prefixingAlternativeIndex + 1; !found && subjectAlternativeIndex < orMatcher.children.length; ++subjectAlternativeIndex) {
                    List<List<Token>> subjects = partialMatches.get(subjectAlternativeIndex);
                    if (subjects == null) continue;
                    int prefixIndex = 0;
                    for (List<Token> subject : subjects) {
                        if (this.isPrefix(prefix, subject)) {
                            alternativesPrefixes.put(prefixingAlternativeIndex, prefix);
                            if (alreadyAdded.get(subjectAlternativeIndex) != null && !alreadyAdded.get(subjectAlternativeIndex).contains(prefixIndex)) {
                                alreadyAdded.put(subjectAlternativeIndex, prefixIndex);
                                alternativesPrefixes.put(subjectAlternativeIndex, subject);
                            }
                            found = true;
                            continue block2;
                        }
                        ++prefixIndex;
                    }
                }
            }
        }
    }

    private void analyse(Matcher matcher) {
        if (matcher instanceof OrMatcher) {
            LinkedListMultimap<Integer, List<Token>> alternativesPrefixes = LinkedListMultimap.create();
            for (int alternativeIndex = 0; alternativeIndex < matcher.children.length; ++alternativeIndex) {
                alternativesPrefixes.put(alternativeIndex, new LinkedList());
            }
            AutoCompleter autoCompleter = new AutoCompleter();
            for (int tokens = 0; tokens < this.maxTokens && !alternativesPrefixes.isEmpty(); ++tokens) {
                LinkedListMultimap<Integer, List<Token>> fullMatches = LinkedListMultimap.create();
                LinkedListMultimap<Integer, List<Token>> partialMatches = LinkedListMultimap.create();
                for (Map.Entry entry : alternativesPrefixes.entries()) {
                    autoCompleter.autoComplete(matcher.children[(Integer)entry.getKey()], (List)entry.getValue(), 1);
                    fullMatches.putAll((Integer)entry.getKey(), (Iterable<List<Token>>)autoCompleter.getFullMatches());
                    partialMatches.putAll((Integer)entry.getKey(), (Iterable<List<Token>>)autoCompleter.getPartialMatches());
                }
                this.handleEmptyPrefixes((OrMatcher)matcher, fullMatches, partialMatches);
                this.handlePrefixes((OrMatcher)matcher, fullMatches, fullMatches, this.prefixAlternativeViolations, ViolationConfidence.SURE, partialMatches);
                this.handlePrefixes((OrMatcher)matcher, fullMatches, partialMatches, this.prefixAlternativeViolations, ViolationConfidence.HIGH, null);
                alternativesPrefixes.clear();
                this.handlePartialPrefixes((OrMatcher)matcher, partialMatches, alternativesPrefixes);
            }
            if (!alternativesPrefixes.isEmpty()) {
                this.handlePrefixes((OrMatcher)matcher, alternativesPrefixes, alternativesPrefixes, this.potentialPrefixAlternativeViolations, ViolationConfidence.LOW, null);
            }
        }
    }

    public void analyseMatcherTree(Matcher rootMatcher) {
        this.emptyAlternativeViolations = new LinkedList<Violation>();
        this.prefixAlternativeViolations = new LinkedList<Violation>();
        this.potentialPrefixAlternativeViolations = new LinkedList<Violation>();
        this.analyseMatcherTree(rootMatcher, new HashSet<Matcher>());
    }

    private void analyseMatcherTree(Matcher rootMatcher, Set<Matcher> alreadyVisitedMatchers) {
        RuleMatcher previousRule = null;
        if (rootMatcher instanceof RuleMatcher) {
            previousRule = this.currentRule;
            this.currentRule = (RuleMatcher)rootMatcher;
        }
        this.analyse(rootMatcher);
        alreadyVisitedMatchers.add(rootMatcher);
        for (Matcher child : rootMatcher.children) {
            if (!alreadyVisitedMatchers.add(child)) continue;
            this.analyseMatcherTree(child, alreadyVisitedMatchers);
        }
        if (rootMatcher instanceof RuleMatcher) {
            this.currentRule = previousRule;
        }
    }

    public List<Violation> getEmptyAlternativeViolations() {
        return this.emptyAlternativeViolations;
    }

    public List<Violation> getPrefixAlternativeViolations() {
        return this.prefixAlternativeViolations;
    }

    public List<Violation> getPotentialPrefixAlternativeViolations() {
        return this.potentialPrefixAlternativeViolations;
    }
}

